/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.IamResponse;
import software.amazon.awssdk.services.iam.model.ListPoliciesGrantingServiceAccessEntry;
import software.amazon.awssdk.services.iam.model._listPolicyGrantingServiceAccessResponseListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPoliciesGrantingServiceAccessResponse
extends IamResponse
implements ToCopyableBuilder<Builder, ListPoliciesGrantingServiceAccessResponse> {
    private static final SdkField<List<ListPoliciesGrantingServiceAccessEntry>> POLICIES_GRANTING_SERVICE_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListPoliciesGrantingServiceAccessResponse.getter(ListPoliciesGrantingServiceAccessResponse::policiesGrantingServiceAccess)).setter(ListPoliciesGrantingServiceAccessResponse.setter(Builder::policiesGrantingServiceAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoliciesGrantingServiceAccess").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListPoliciesGrantingServiceAccessEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ListPoliciesGrantingServiceAccessResponse.getter(ListPoliciesGrantingServiceAccessResponse::isTruncated)).setter(ListPoliciesGrantingServiceAccessResponse.setter(Builder::isTruncated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListPoliciesGrantingServiceAccessResponse.getter(ListPoliciesGrantingServiceAccessResponse::marker)).setter(ListPoliciesGrantingServiceAccessResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICIES_GRANTING_SERVICE_ACCESS_FIELD, IS_TRUNCATED_FIELD, MARKER_FIELD));
    private final List<ListPoliciesGrantingServiceAccessEntry> policiesGrantingServiceAccess;
    private final Boolean isTruncated;
    private final String marker;

    private ListPoliciesGrantingServiceAccessResponse(BuilderImpl builder) {
        super(builder);
        this.policiesGrantingServiceAccess = builder.policiesGrantingServiceAccess;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    public boolean hasPoliciesGrantingServiceAccess() {
        return this.policiesGrantingServiceAccess != null && !(this.policiesGrantingServiceAccess instanceof SdkAutoConstructList);
    }

    public List<ListPoliciesGrantingServiceAccessEntry> policiesGrantingServiceAccess() {
        return this.policiesGrantingServiceAccess;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policiesGrantingServiceAccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPoliciesGrantingServiceAccessResponse)) {
            return false;
        }
        ListPoliciesGrantingServiceAccessResponse other = (ListPoliciesGrantingServiceAccessResponse)((Object)obj);
        return Objects.equals(this.policiesGrantingServiceAccess(), other.policiesGrantingServiceAccess()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"ListPoliciesGrantingServiceAccessResponse").add("PoliciesGrantingServiceAccess", this.policiesGrantingServiceAccess()).add("IsTruncated", (Object)this.isTruncated()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PoliciesGrantingServiceAccess": {
                return Optional.ofNullable(clazz.cast(this.policiesGrantingServiceAccess()));
            }
            case "IsTruncated": {
                return Optional.ofNullable(clazz.cast(this.isTruncated()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPoliciesGrantingServiceAccessResponse, T> g) {
        return obj -> g.apply((ListPoliciesGrantingServiceAccessResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamResponse.BuilderImpl
    implements Builder {
        private List<ListPoliciesGrantingServiceAccessEntry> policiesGrantingServiceAccess = DefaultSdkAutoConstructList.getInstance();
        private Boolean isTruncated;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPoliciesGrantingServiceAccessResponse model) {
            super(model);
            this.policiesGrantingServiceAccess(model.policiesGrantingServiceAccess);
            this.isTruncated(model.isTruncated);
            this.marker(model.marker);
        }

        public final Collection<ListPoliciesGrantingServiceAccessEntry.Builder> getPoliciesGrantingServiceAccess() {
            return this.policiesGrantingServiceAccess != null ? (Collection)this.policiesGrantingServiceAccess.stream().map(ListPoliciesGrantingServiceAccessEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder policiesGrantingServiceAccess(Collection<ListPoliciesGrantingServiceAccessEntry> policiesGrantingServiceAccess) {
            this.policiesGrantingServiceAccess = _listPolicyGrantingServiceAccessResponseListTypeCopier.copy(policiesGrantingServiceAccess);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policiesGrantingServiceAccess(ListPoliciesGrantingServiceAccessEntry ... policiesGrantingServiceAccess) {
            this.policiesGrantingServiceAccess(Arrays.asList(policiesGrantingServiceAccess));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policiesGrantingServiceAccess(Consumer<ListPoliciesGrantingServiceAccessEntry.Builder> ... policiesGrantingServiceAccess) {
            this.policiesGrantingServiceAccess(Stream.of(policiesGrantingServiceAccess).map(c -> (ListPoliciesGrantingServiceAccessEntry)((ListPoliciesGrantingServiceAccessEntry.Builder)ListPoliciesGrantingServiceAccessEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPoliciesGrantingServiceAccess(Collection<ListPoliciesGrantingServiceAccessEntry.BuilderImpl> policiesGrantingServiceAccess) {
            this.policiesGrantingServiceAccess = _listPolicyGrantingServiceAccessResponseListTypeCopier.copyFromBuilder(policiesGrantingServiceAccess);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public ListPoliciesGrantingServiceAccessResponse build() {
            return new ListPoliciesGrantingServiceAccessResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPoliciesGrantingServiceAccessResponse> {
        public Builder policiesGrantingServiceAccess(Collection<ListPoliciesGrantingServiceAccessEntry> var1);

        public Builder policiesGrantingServiceAccess(ListPoliciesGrantingServiceAccessEntry ... var1);

        public Builder policiesGrantingServiceAccess(Consumer<ListPoliciesGrantingServiceAccessEntry.Builder> ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);
    }
}

