/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetSecurityTokenServicePreferencesRequest extends IamRequest implements
        ToCopyableBuilder<SetSecurityTokenServicePreferencesRequest.Builder, SetSecurityTokenServicePreferencesRequest> {
    private static final SdkField<String> GLOBAL_ENDPOINT_TOKEN_VERSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(SetSecurityTokenServicePreferencesRequest::globalEndpointTokenVersionAsString))
            .setter(setter(Builder::globalEndpointTokenVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalEndpointTokenVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(GLOBAL_ENDPOINT_TOKEN_VERSION_FIELD));

    private final String globalEndpointTokenVersion;

    private SetSecurityTokenServicePreferencesRequest(BuilderImpl builder) {
        super(builder);
        this.globalEndpointTokenVersion = builder.globalEndpointTokenVersion;
    }

    /**
     * <p>
     * The version of the global endpoint token. Version 1 tokens are valid only in AWS Regions that are available by
     * default. These tokens do not work in manually enabled Regions, such as Asia Pacific (Hong Kong). Version 2 tokens
     * are valid in all Regions. However, version 2 tokens are longer and might affect systems where you temporarily
     * store tokens.
     * </p>
     * <p>
     * For information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and
     * Deactivating STS in an AWS Region</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #globalEndpointTokenVersion} will return {@link GlobalEndpointTokenVersion#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #globalEndpointTokenVersionAsString}.
     * </p>
     * 
     * @return The version of the global endpoint token. Version 1 tokens are valid only in AWS Regions that are
     *         available by default. These tokens do not work in manually enabled Regions, such as Asia Pacific (Hong
     *         Kong). Version 2 tokens are valid in all Regions. However, version 2 tokens are longer and might affect
     *         systems where you temporarily store tokens.</p>
     *         <p>
     *         For information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html"
     *         >Activating and Deactivating STS in an AWS Region</a> in the <i>IAM User Guide</i>.
     * @see GlobalEndpointTokenVersion
     */
    public GlobalEndpointTokenVersion globalEndpointTokenVersion() {
        return GlobalEndpointTokenVersion.fromValue(globalEndpointTokenVersion);
    }

    /**
     * <p>
     * The version of the global endpoint token. Version 1 tokens are valid only in AWS Regions that are available by
     * default. These tokens do not work in manually enabled Regions, such as Asia Pacific (Hong Kong). Version 2 tokens
     * are valid in all Regions. However, version 2 tokens are longer and might affect systems where you temporarily
     * store tokens.
     * </p>
     * <p>
     * For information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and
     * Deactivating STS in an AWS Region</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #globalEndpointTokenVersion} will return {@link GlobalEndpointTokenVersion#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #globalEndpointTokenVersionAsString}.
     * </p>
     * 
     * @return The version of the global endpoint token. Version 1 tokens are valid only in AWS Regions that are
     *         available by default. These tokens do not work in manually enabled Regions, such as Asia Pacific (Hong
     *         Kong). Version 2 tokens are valid in all Regions. However, version 2 tokens are longer and might affect
     *         systems where you temporarily store tokens.</p>
     *         <p>
     *         For information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html"
     *         >Activating and Deactivating STS in an AWS Region</a> in the <i>IAM User Guide</i>.
     * @see GlobalEndpointTokenVersion
     */
    public String globalEndpointTokenVersionAsString() {
        return globalEndpointTokenVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(globalEndpointTokenVersionAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetSecurityTokenServicePreferencesRequest)) {
            return false;
        }
        SetSecurityTokenServicePreferencesRequest other = (SetSecurityTokenServicePreferencesRequest) obj;
        return Objects.equals(globalEndpointTokenVersionAsString(), other.globalEndpointTokenVersionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SetSecurityTokenServicePreferencesRequest")
                .add("GlobalEndpointTokenVersion", globalEndpointTokenVersionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalEndpointTokenVersion":
            return Optional.ofNullable(clazz.cast(globalEndpointTokenVersionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetSecurityTokenServicePreferencesRequest, T> g) {
        return obj -> g.apply((SetSecurityTokenServicePreferencesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, SetSecurityTokenServicePreferencesRequest> {
        /**
         * <p>
         * The version of the global endpoint token. Version 1 tokens are valid only in AWS Regions that are available
         * by default. These tokens do not work in manually enabled Regions, such as Asia Pacific (Hong Kong). Version 2
         * tokens are valid in all Regions. However, version 2 tokens are longer and might affect systems where you
         * temporarily store tokens.
         * </p>
         * <p>
         * For information, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating
         * and Deactivating STS in an AWS Region</a> in the <i>IAM User Guide</i>.
         * </p>
         * 
         * @param globalEndpointTokenVersion
         *        The version of the global endpoint token. Version 1 tokens are valid only in AWS Regions that are
         *        available by default. These tokens do not work in manually enabled Regions, such as Asia Pacific (Hong
         *        Kong). Version 2 tokens are valid in all Regions. However, version 2 tokens are longer and might
         *        affect systems where you temporarily store tokens.</p>
         *        <p>
         *        For information, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html"
         *        >Activating and Deactivating STS in an AWS Region</a> in the <i>IAM User Guide</i>.
         * @see GlobalEndpointTokenVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GlobalEndpointTokenVersion
         */
        Builder globalEndpointTokenVersion(String globalEndpointTokenVersion);

        /**
         * <p>
         * The version of the global endpoint token. Version 1 tokens are valid only in AWS Regions that are available
         * by default. These tokens do not work in manually enabled Regions, such as Asia Pacific (Hong Kong). Version 2
         * tokens are valid in all Regions. However, version 2 tokens are longer and might affect systems where you
         * temporarily store tokens.
         * </p>
         * <p>
         * For information, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating
         * and Deactivating STS in an AWS Region</a> in the <i>IAM User Guide</i>.
         * </p>
         * 
         * @param globalEndpointTokenVersion
         *        The version of the global endpoint token. Version 1 tokens are valid only in AWS Regions that are
         *        available by default. These tokens do not work in manually enabled Regions, such as Asia Pacific (Hong
         *        Kong). Version 2 tokens are valid in all Regions. However, version 2 tokens are longer and might
         *        affect systems where you temporarily store tokens.</p>
         *        <p>
         *        For information, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html"
         *        >Activating and Deactivating STS in an AWS Region</a> in the <i>IAM User Guide</i>.
         * @see GlobalEndpointTokenVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GlobalEndpointTokenVersion
         */
        Builder globalEndpointTokenVersion(GlobalEndpointTokenVersion globalEndpointTokenVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IamRequest.BuilderImpl implements Builder {
        private String globalEndpointTokenVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(SetSecurityTokenServicePreferencesRequest model) {
            super(model);
            globalEndpointTokenVersion(model.globalEndpointTokenVersion);
        }

        public final String getGlobalEndpointTokenVersion() {
            return globalEndpointTokenVersion;
        }

        @Override
        public final Builder globalEndpointTokenVersion(String globalEndpointTokenVersion) {
            this.globalEndpointTokenVersion = globalEndpointTokenVersion;
            return this;
        }

        @Override
        public final Builder globalEndpointTokenVersion(GlobalEndpointTokenVersion globalEndpointTokenVersion) {
            this.globalEndpointTokenVersion(globalEndpointTokenVersion == null ? null : globalEndpointTokenVersion.toString());
            return this;
        }

        public final void setGlobalEndpointTokenVersion(String globalEndpointTokenVersion) {
            this.globalEndpointTokenVersion = globalEndpointTokenVersion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetSecurityTokenServicePreferencesRequest build() {
            return new SetSecurityTokenServicePreferencesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
