/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetServiceLinkedRoleDeletionStatusResponse extends IamResponse implements
        ToCopyableBuilder<GetServiceLinkedRoleDeletionStatusResponse.Builder, GetServiceLinkedRoleDeletionStatusResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetServiceLinkedRoleDeletionStatusResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<DeletionTaskFailureReasonType> REASON_FIELD = SdkField
            .<DeletionTaskFailureReasonType> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetServiceLinkedRoleDeletionStatusResponse::reason)).setter(setter(Builder::reason))
            .constructor(DeletionTaskFailureReasonType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, REASON_FIELD));

    private final String status;

    private final DeletionTaskFailureReasonType reason;

    private GetServiceLinkedRoleDeletionStatusResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.reason = builder.reason;
    }

    /**
     * <p>
     * The status of the deletion.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DeletionTaskStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the deletion.
     * @see DeletionTaskStatusType
     */
    public DeletionTaskStatusType status() {
        return DeletionTaskStatusType.fromValue(status);
    }

    /**
     * <p>
     * The status of the deletion.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DeletionTaskStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the deletion.
     * @see DeletionTaskStatusType
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * An object that contains details about the reason the deletion failed.
     * </p>
     * 
     * @return An object that contains details about the reason the deletion failed.
     */
    public DeletionTaskFailureReasonType reason() {
        return reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServiceLinkedRoleDeletionStatusResponse)) {
            return false;
        }
        GetServiceLinkedRoleDeletionStatusResponse other = (GetServiceLinkedRoleDeletionStatusResponse) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(reason(), other.reason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetServiceLinkedRoleDeletionStatusResponse").add("Status", statusAsString())
                .add("Reason", reason()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Reason":
            return Optional.ofNullable(clazz.cast(reason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetServiceLinkedRoleDeletionStatusResponse, T> g) {
        return obj -> g.apply((GetServiceLinkedRoleDeletionStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetServiceLinkedRoleDeletionStatusResponse> {
        /**
         * <p>
         * The status of the deletion.
         * </p>
         * 
         * @param status
         *        The status of the deletion.
         * @see DeletionTaskStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeletionTaskStatusType
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the deletion.
         * </p>
         * 
         * @param status
         *        The status of the deletion.
         * @see DeletionTaskStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeletionTaskStatusType
         */
        Builder status(DeletionTaskStatusType status);

        /**
         * <p>
         * An object that contains details about the reason the deletion failed.
         * </p>
         * 
         * @param reason
         *        An object that contains details about the reason the deletion failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(DeletionTaskFailureReasonType reason);

        /**
         * <p>
         * An object that contains details about the reason the deletion failed.
         * </p>
         * This is a convenience that creates an instance of the {@link DeletionTaskFailureReasonType.Builder} avoiding
         * the need to create one manually via {@link DeletionTaskFailureReasonType#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeletionTaskFailureReasonType.Builder#build()} is called
         * immediately and its result is passed to {@link #reason(DeletionTaskFailureReasonType)}.
         * 
         * @param reason
         *        a consumer that will call methods on {@link DeletionTaskFailureReasonType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reason(DeletionTaskFailureReasonType)
         */
        default Builder reason(Consumer<DeletionTaskFailureReasonType.Builder> reason) {
            return reason(DeletionTaskFailureReasonType.builder().applyMutation(reason).build());
        }
    }

    static final class BuilderImpl extends IamResponse.BuilderImpl implements Builder {
        private String status;

        private DeletionTaskFailureReasonType reason;

        private BuilderImpl() {
        }

        private BuilderImpl(GetServiceLinkedRoleDeletionStatusResponse model) {
            super(model);
            status(model.status);
            reason(model.reason);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DeletionTaskStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final DeletionTaskFailureReasonType.Builder getReason() {
            return reason != null ? reason.toBuilder() : null;
        }

        @Override
        public final Builder reason(DeletionTaskFailureReasonType reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(DeletionTaskFailureReasonType.BuilderImpl reason) {
            this.reason = reason != null ? reason.build() : null;
        }

        @Override
        public GetServiceLinkedRoleDeletionStatusResponse build() {
            return new GetServiceLinkedRoleDeletionStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
