/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains additional details about a service-specific credential.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceSpecificCredentialMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceSpecificCredentialMetadata.Builder, ServiceSpecificCredentialMetadata> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceSpecificCredentialMetadata::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceSpecificCredentialMetadata::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> SERVICE_USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceSpecificCredentialMetadata::serviceUserName)).setter(setter(Builder::serviceUserName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUserName").build()).build();

    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ServiceSpecificCredentialMetadata::createDate)).setter(setter(Builder::createDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()).build();

    private static final SdkField<String> SERVICE_SPECIFIC_CREDENTIAL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceSpecificCredentialMetadata::serviceSpecificCredentialId))
            .setter(setter(Builder::serviceSpecificCredentialId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceSpecificCredentialId")
                    .build()).build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceSpecificCredentialMetadata::serviceName)).setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAME_FIELD, STATUS_FIELD,
            SERVICE_USER_NAME_FIELD, CREATE_DATE_FIELD, SERVICE_SPECIFIC_CREDENTIAL_ID_FIELD, SERVICE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String userName;

    private final String status;

    private final String serviceUserName;

    private final Instant createDate;

    private final String serviceSpecificCredentialId;

    private final String serviceName;

    private ServiceSpecificCredentialMetadata(BuilderImpl builder) {
        this.userName = builder.userName;
        this.status = builder.status;
        this.serviceUserName = builder.serviceUserName;
        this.createDate = builder.createDate;
        this.serviceSpecificCredentialId = builder.serviceSpecificCredentialId;
        this.serviceName = builder.serviceName;
    }

    /**
     * <p>
     * The name of the IAM user associated with the service-specific credential.
     * </p>
     * 
     * @return The name of the IAM user associated with the service-specific credential.
     */
    public String userName() {
        return userName;
    }

    /**
     * <p>
     * The status of the service-specific credential. <code>Active</code> means that the key is valid for API calls,
     * while <code>Inactive</code> means it is not.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the service-specific credential. <code>Active</code> means that the key is valid for API
     *         calls, while <code>Inactive</code> means it is not.
     * @see StatusType
     */
    public StatusType status() {
        return StatusType.fromValue(status);
    }

    /**
     * <p>
     * The status of the service-specific credential. <code>Active</code> means that the key is valid for API calls,
     * while <code>Inactive</code> means it is not.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the service-specific credential. <code>Active</code> means that the key is valid for API
     *         calls, while <code>Inactive</code> means it is not.
     * @see StatusType
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The generated user name for the service-specific credential.
     * </p>
     * 
     * @return The generated user name for the service-specific credential.
     */
    public String serviceUserName() {
        return serviceUserName;
    }

    /**
     * <p>
     * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the
     * service-specific credential were created.
     * </p>
     * 
     * @return The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the
     *         service-specific credential were created.
     */
    public Instant createDate() {
        return createDate;
    }

    /**
     * <p>
     * The unique identifier for the service-specific credential.
     * </p>
     * 
     * @return The unique identifier for the service-specific credential.
     */
    public String serviceSpecificCredentialId() {
        return serviceSpecificCredentialId;
    }

    /**
     * <p>
     * The name of the service associated with the service-specific credential.
     * </p>
     * 
     * @return The name of the service associated with the service-specific credential.
     */
    public String serviceName() {
        return serviceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serviceUserName());
        hashCode = 31 * hashCode + Objects.hashCode(createDate());
        hashCode = 31 * hashCode + Objects.hashCode(serviceSpecificCredentialId());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceSpecificCredentialMetadata)) {
            return false;
        }
        ServiceSpecificCredentialMetadata other = (ServiceSpecificCredentialMetadata) obj;
        return Objects.equals(userName(), other.userName()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(serviceUserName(), other.serviceUserName()) && Objects.equals(createDate(), other.createDate())
                && Objects.equals(serviceSpecificCredentialId(), other.serviceSpecificCredentialId())
                && Objects.equals(serviceName(), other.serviceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ServiceSpecificCredentialMetadata").add("UserName", userName()).add("Status", statusAsString())
                .add("ServiceUserName", serviceUserName()).add("CreateDate", createDate())
                .add("ServiceSpecificCredentialId", serviceSpecificCredentialId()).add("ServiceName", serviceName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ServiceUserName":
            return Optional.ofNullable(clazz.cast(serviceUserName()));
        case "CreateDate":
            return Optional.ofNullable(clazz.cast(createDate()));
        case "ServiceSpecificCredentialId":
            return Optional.ofNullable(clazz.cast(serviceSpecificCredentialId()));
        case "ServiceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceSpecificCredentialMetadata, T> g) {
        return obj -> g.apply((ServiceSpecificCredentialMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceSpecificCredentialMetadata> {
        /**
         * <p>
         * The name of the IAM user associated with the service-specific credential.
         * </p>
         * 
         * @param userName
         *        The name of the IAM user associated with the service-specific credential.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * The status of the service-specific credential. <code>Active</code> means that the key is valid for API calls,
         * while <code>Inactive</code> means it is not.
         * </p>
         * 
         * @param status
         *        The status of the service-specific credential. <code>Active</code> means that the key is valid for API
         *        calls, while <code>Inactive</code> means it is not.
         * @see StatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusType
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the service-specific credential. <code>Active</code> means that the key is valid for API calls,
         * while <code>Inactive</code> means it is not.
         * </p>
         * 
         * @param status
         *        The status of the service-specific credential. <code>Active</code> means that the key is valid for API
         *        calls, while <code>Inactive</code> means it is not.
         * @see StatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusType
         */
        Builder status(StatusType status);

        /**
         * <p>
         * The generated user name for the service-specific credential.
         * </p>
         * 
         * @param serviceUserName
         *        The generated user name for the service-specific credential.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceUserName(String serviceUserName);

        /**
         * <p>
         * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the
         * service-specific credential were created.
         * </p>
         * 
         * @param createDate
         *        The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the
         *        service-specific credential were created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(Instant createDate);

        /**
         * <p>
         * The unique identifier for the service-specific credential.
         * </p>
         * 
         * @param serviceSpecificCredentialId
         *        The unique identifier for the service-specific credential.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceSpecificCredentialId(String serviceSpecificCredentialId);

        /**
         * <p>
         * The name of the service associated with the service-specific credential.
         * </p>
         * 
         * @param serviceName
         *        The name of the service associated with the service-specific credential.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);
    }

    static final class BuilderImpl implements Builder {
        private String userName;

        private String status;

        private String serviceUserName;

        private Instant createDate;

        private String serviceSpecificCredentialId;

        private String serviceName;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceSpecificCredentialMetadata model) {
            userName(model.userName);
            status(model.status);
            serviceUserName(model.serviceUserName);
            createDate(model.createDate);
            serviceSpecificCredentialId(model.serviceSpecificCredentialId);
            serviceName(model.serviceName);
        }

        public final String getUserName() {
            return userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getServiceUserName() {
            return serviceUserName;
        }

        @Override
        public final Builder serviceUserName(String serviceUserName) {
            this.serviceUserName = serviceUserName;
            return this;
        }

        public final void setServiceUserName(String serviceUserName) {
            this.serviceUserName = serviceUserName;
        }

        public final Instant getCreateDate() {
            return createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final String getServiceSpecificCredentialId() {
            return serviceSpecificCredentialId;
        }

        @Override
        public final Builder serviceSpecificCredentialId(String serviceSpecificCredentialId) {
            this.serviceSpecificCredentialId = serviceSpecificCredentialId;
            return this;
        }

        public final void setServiceSpecificCredentialId(String serviceSpecificCredentialId) {
            this.serviceSpecificCredentialId = serviceSpecificCredentialId;
        }

        public final String getServiceName() {
            return serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public ServiceSpecificCredentialMetadata build() {
            return new ServiceSpecificCredentialMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
