/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a successful <a>GetContextKeysForPrincipalPolicy</a> or <a>GetContextKeysForCustomPolicy</a>
 * request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetContextKeysForCustomPolicyResponse extends IamResponse implements
        ToCopyableBuilder<GetContextKeysForCustomPolicyResponse.Builder, GetContextKeysForCustomPolicyResponse> {
    private static final SdkField<List<String>> CONTEXT_KEY_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(GetContextKeysForCustomPolicyResponse::contextKeyNames))
            .setter(setter(Builder::contextKeyNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextKeyNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTEXT_KEY_NAMES_FIELD));

    private final List<String> contextKeyNames;

    private GetContextKeysForCustomPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.contextKeyNames = builder.contextKeyNames;
    }

    /**
     * Returns true if the ContextKeyNames property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasContextKeyNames() {
        return contextKeyNames != null && !(contextKeyNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of context keys that are referenced in the input policies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasContextKeyNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of context keys that are referenced in the input policies.
     */
    public List<String> contextKeyNames() {
        return contextKeyNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contextKeyNames());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContextKeysForCustomPolicyResponse)) {
            return false;
        }
        GetContextKeysForCustomPolicyResponse other = (GetContextKeysForCustomPolicyResponse) obj;
        return Objects.equals(contextKeyNames(), other.contextKeyNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetContextKeysForCustomPolicyResponse").add("ContextKeyNames", contextKeyNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContextKeyNames":
            return Optional.ofNullable(clazz.cast(contextKeyNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetContextKeysForCustomPolicyResponse, T> g) {
        return obj -> g.apply((GetContextKeysForCustomPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetContextKeysForCustomPolicyResponse> {
        /**
         * <p>
         * The list of context keys that are referenced in the input policies.
         * </p>
         * 
         * @param contextKeyNames
         *        The list of context keys that are referenced in the input policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextKeyNames(Collection<String> contextKeyNames);

        /**
         * <p>
         * The list of context keys that are referenced in the input policies.
         * </p>
         * 
         * @param contextKeyNames
         *        The list of context keys that are referenced in the input policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextKeyNames(String... contextKeyNames);
    }

    static final class BuilderImpl extends IamResponse.BuilderImpl implements Builder {
        private List<String> contextKeyNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetContextKeysForCustomPolicyResponse model) {
            super(model);
            contextKeyNames(model.contextKeyNames);
        }

        public final Collection<String> getContextKeyNames() {
            return contextKeyNames;
        }

        @Override
        public final Builder contextKeyNames(Collection<String> contextKeyNames) {
            this.contextKeyNames = ContextKeyNamesResultListTypeCopier.copy(contextKeyNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contextKeyNames(String... contextKeyNames) {
            contextKeyNames(Arrays.asList(contextKeyNames));
            return this;
        }

        public final void setContextKeyNames(Collection<String> contextKeyNames) {
            this.contextKeyNames = ContextKeyNamesResultListTypeCopier.copy(contextKeyNames);
        }

        @Override
        public GetContextKeysForCustomPolicyResponse build() {
            return new GetContextKeysForCustomPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
