/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteAccountAliasRequest extends IamRequest implements
        ToCopyableBuilder<DeleteAccountAliasRequest.Builder, DeleteAccountAliasRequest> {
    private static final SdkField<String> ACCOUNT_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteAccountAliasRequest::accountAlias)).setter(setter(Builder::accountAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountAlias").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ALIAS_FIELD));

    private final String accountAlias;

    private DeleteAccountAliasRequest(BuilderImpl builder) {
        super(builder);
        this.accountAlias = builder.accountAlias;
    }

    /**
     * <p>
     * The name of the account alias to delete.
     * </p>
     * <p>
     * This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of
     * characters consisting of lowercase letters, digits, and dashes. You cannot start or finish with a dash, nor can
     * you have two dashes in a row.
     * </p>
     * 
     * @return The name of the account alias to delete.</p>
     *         <p>
     *         This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string
     *         of characters consisting of lowercase letters, digits, and dashes. You cannot start or finish with a
     *         dash, nor can you have two dashes in a row.
     */
    public String accountAlias() {
        return accountAlias;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountAlias());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAccountAliasRequest)) {
            return false;
        }
        DeleteAccountAliasRequest other = (DeleteAccountAliasRequest) obj;
        return Objects.equals(accountAlias(), other.accountAlias());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteAccountAliasRequest").add("AccountAlias", accountAlias()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountAlias":
            return Optional.ofNullable(clazz.cast(accountAlias()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAccountAliasRequest, T> g) {
        return obj -> g.apply((DeleteAccountAliasRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteAccountAliasRequest> {
        /**
         * <p>
         * The name of the account alias to delete.
         * </p>
         * <p>
         * This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of
         * characters consisting of lowercase letters, digits, and dashes. You cannot start or finish with a dash, nor
         * can you have two dashes in a row.
         * </p>
         * 
         * @param accountAlias
         *        The name of the account alias to delete.</p>
         *        <p>
         *        This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a
         *        string of characters consisting of lowercase letters, digits, and dashes. You cannot start or finish
         *        with a dash, nor can you have two dashes in a row.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountAlias(String accountAlias);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IamRequest.BuilderImpl implements Builder {
        private String accountAlias;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAccountAliasRequest model) {
            super(model);
            accountAlias(model.accountAlias);
        }

        public final String getAccountAlias() {
            return accountAlias;
        }

        @Override
        public final Builder accountAlias(String accountAlias) {
            this.accountAlias = accountAlias;
            return this;
        }

        public final void setAccountAlias(String accountAlias) {
            this.accountAlias = accountAlias;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAccountAliasRequest build() {
            return new DeleteAccountAliasRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
