/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateServiceSpecificCredentialResponse extends IamResponse implements
        ToCopyableBuilder<CreateServiceSpecificCredentialResponse.Builder, CreateServiceSpecificCredentialResponse> {
    private static final SdkField<ServiceSpecificCredential> SERVICE_SPECIFIC_CREDENTIAL_FIELD = SdkField
            .<ServiceSpecificCredential> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateServiceSpecificCredentialResponse::serviceSpecificCredential))
            .setter(setter(Builder::serviceSpecificCredential)).constructor(ServiceSpecificCredential::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceSpecificCredential").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SERVICE_SPECIFIC_CREDENTIAL_FIELD));

    private final ServiceSpecificCredential serviceSpecificCredential;

    private CreateServiceSpecificCredentialResponse(BuilderImpl builder) {
        super(builder);
        this.serviceSpecificCredential = builder.serviceSpecificCredential;
    }

    /**
     * <p>
     * A structure that contains information about the newly created service-specific credential.
     * </p>
     * <important>
     * <p>
     * This is the only time that the password for this credential set is available. It cannot be recovered later.
     * Instead, you must reset the password with <a>ResetServiceSpecificCredential</a>.
     * </p>
     * </important>
     * 
     * @return A structure that contains information about the newly created service-specific credential.</p>
     *         <important>
     *         <p>
     *         This is the only time that the password for this credential set is available. It cannot be recovered
     *         later. Instead, you must reset the password with <a>ResetServiceSpecificCredential</a>.
     *         </p>
     */
    public ServiceSpecificCredential serviceSpecificCredential() {
        return serviceSpecificCredential;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceSpecificCredential());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServiceSpecificCredentialResponse)) {
            return false;
        }
        CreateServiceSpecificCredentialResponse other = (CreateServiceSpecificCredentialResponse) obj;
        return Objects.equals(serviceSpecificCredential(), other.serviceSpecificCredential());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateServiceSpecificCredentialResponse")
                .add("ServiceSpecificCredential", serviceSpecificCredential()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceSpecificCredential":
            return Optional.ofNullable(clazz.cast(serviceSpecificCredential()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateServiceSpecificCredentialResponse, T> g) {
        return obj -> g.apply((CreateServiceSpecificCredentialResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateServiceSpecificCredentialResponse> {
        /**
         * <p>
         * A structure that contains information about the newly created service-specific credential.
         * </p>
         * <important>
         * <p>
         * This is the only time that the password for this credential set is available. It cannot be recovered later.
         * Instead, you must reset the password with <a>ResetServiceSpecificCredential</a>.
         * </p>
         * </important>
         * 
         * @param serviceSpecificCredential
         *        A structure that contains information about the newly created service-specific credential.</p>
         *        <important>
         *        <p>
         *        This is the only time that the password for this credential set is available. It cannot be recovered
         *        later. Instead, you must reset the password with <a>ResetServiceSpecificCredential</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceSpecificCredential(ServiceSpecificCredential serviceSpecificCredential);

        /**
         * <p>
         * A structure that contains information about the newly created service-specific credential.
         * </p>
         * <important>
         * <p>
         * This is the only time that the password for this credential set is available. It cannot be recovered later.
         * Instead, you must reset the password with <a>ResetServiceSpecificCredential</a>.
         * </p>
         * </important> This is a convenience that creates an instance of the {@link ServiceSpecificCredential.Builder}
         * avoiding the need to create one manually via {@link ServiceSpecificCredential#builder()}.
         *
         * When the {@link Consumer} completes, {@link ServiceSpecificCredential.Builder#build()} is called immediately
         * and its result is passed to {@link #serviceSpecificCredential(ServiceSpecificCredential)}.
         * 
         * @param serviceSpecificCredential
         *        a consumer that will call methods on {@link ServiceSpecificCredential.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceSpecificCredential(ServiceSpecificCredential)
         */
        default Builder serviceSpecificCredential(Consumer<ServiceSpecificCredential.Builder> serviceSpecificCredential) {
            return serviceSpecificCredential(ServiceSpecificCredential.builder().applyMutation(serviceSpecificCredential).build());
        }
    }

    static final class BuilderImpl extends IamResponse.BuilderImpl implements Builder {
        private ServiceSpecificCredential serviceSpecificCredential;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServiceSpecificCredentialResponse model) {
            super(model);
            serviceSpecificCredential(model.serviceSpecificCredential);
        }

        public final ServiceSpecificCredential.Builder getServiceSpecificCredential() {
            return serviceSpecificCredential != null ? serviceSpecificCredential.toBuilder() : null;
        }

        @Override
        public final Builder serviceSpecificCredential(ServiceSpecificCredential serviceSpecificCredential) {
            this.serviceSpecificCredential = serviceSpecificCredential;
            return this;
        }

        public final void setServiceSpecificCredential(ServiceSpecificCredential.BuilderImpl serviceSpecificCredential) {
            this.serviceSpecificCredential = serviceSpecificCredential != null ? serviceSpecificCredential.build() : null;
        }

        @Override
        public CreateServiceSpecificCredentialResponse build() {
            return new CreateServiceSpecificCredentialResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
