/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.iam.IAMAsyncClient;
import software.amazon.awssdk.services.iam.model.ListSigningCertificatesRequest;
import software.amazon.awssdk.services.iam.model.ListSigningCertificatesResponse;
import software.amazon.awssdk.services.iam.model.SigningCertificate;

public class ListSigningCertificatesPublisher
implements SdkPublisher<ListSigningCertificatesResponse> {
    private final IAMAsyncClient client;
    private final ListSigningCertificatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSigningCertificatesPublisher(IAMAsyncClient client, ListSigningCertificatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSigningCertificatesPublisher(IAMAsyncClient client, ListSigningCertificatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSigningCertificatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSigningCertificatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<SigningCertificate> certificates() {
        Function<ListSigningCertificatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.certificates() != null) {
                return response.certificates().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new ListSigningCertificatesResponseFetcher(), getIterator, this.isLastPage);
    }

    public final ListSigningCertificatesPublisher resume(ListSigningCertificatesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListSigningCertificatesPublisher(this.client, (ListSigningCertificatesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListSigningCertificatesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListSigningCertificatesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListSigningCertificatesResponseFetcher
    implements AsyncPageFetcher<ListSigningCertificatesResponse> {
        private ListSigningCertificatesResponseFetcher() {
        }

        public boolean hasNextPage(ListSigningCertificatesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public CompletableFuture<ListSigningCertificatesResponse> nextPage(ListSigningCertificatesResponse previousPage) {
            if (previousPage == null) {
                return ListSigningCertificatesPublisher.this.client.listSigningCertificates(ListSigningCertificatesPublisher.this.firstRequest);
            }
            return ListSigningCertificatesPublisher.this.client.listSigningCertificates((ListSigningCertificatesRequest)((Object)ListSigningCertificatesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

