/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.ListRolePoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListRolePoliciesResponse;

public class ListRolePoliciesIterable
implements SdkIterable<ListRolePoliciesResponse> {
    private final IAMClient client;
    private final ListRolePoliciesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRolePoliciesIterable(IAMClient client, ListRolePoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListRolePoliciesResponseFetcher();
    }

    public Iterator<ListRolePoliciesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<String> policyNames() {
        Function<ListRolePoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.policyNames() != null) {
                return response.policyNames().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListRolePoliciesIterable resume(ListRolePoliciesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListRolePoliciesIterable(this.client, (ListRolePoliciesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListRolePoliciesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListRolePoliciesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListRolePoliciesResponseFetcher
    implements SyncPageFetcher<ListRolePoliciesResponse> {
        private ListRolePoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListRolePoliciesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListRolePoliciesResponse nextPage(ListRolePoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListRolePoliciesIterable.this.client.listRolePolicies(ListRolePoliciesIterable.this.firstRequest);
            }
            return ListRolePoliciesIterable.this.client.listRolePolicies((ListRolePoliciesRequest)((Object)ListRolePoliciesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

