/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyRequest;
import software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyResponse;
import software.amazon.awssdk.services.iam.model.PolicyGroup;
import software.amazon.awssdk.services.iam.model.PolicyRole;
import software.amazon.awssdk.services.iam.model.PolicyUser;

public class ListEntitiesForPolicyIterable
implements SdkIterable<ListEntitiesForPolicyResponse> {
    private final IAMClient client;
    private final ListEntitiesForPolicyRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEntitiesForPolicyIterable(IAMClient client, ListEntitiesForPolicyRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListEntitiesForPolicyResponseFetcher();
    }

    public Iterator<ListEntitiesForPolicyResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<PolicyGroup> policyGroups() {
        Function<ListEntitiesForPolicyResponse, Iterator> getIterator = response -> {
            if (response != null && response.policyGroups() != null) {
                return response.policyGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final SdkIterable<PolicyUser> policyUsers() {
        Function<ListEntitiesForPolicyResponse, Iterator> getIterator = response -> {
            if (response != null && response.policyUsers() != null) {
                return response.policyUsers().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final SdkIterable<PolicyRole> policyRoles() {
        Function<ListEntitiesForPolicyResponse, Iterator> getIterator = response -> {
            if (response != null && response.policyRoles() != null) {
                return response.policyRoles().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListEntitiesForPolicyIterable resume(ListEntitiesForPolicyResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListEntitiesForPolicyIterable(this.client, (ListEntitiesForPolicyRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListEntitiesForPolicyIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListEntitiesForPolicyResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListEntitiesForPolicyResponseFetcher
    implements SyncPageFetcher<ListEntitiesForPolicyResponse> {
        private ListEntitiesForPolicyResponseFetcher() {
        }

        public boolean hasNextPage(ListEntitiesForPolicyResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListEntitiesForPolicyResponse nextPage(ListEntitiesForPolicyResponse previousPage) {
            if (previousPage == null) {
                return ListEntitiesForPolicyIterable.this.client.listEntitiesForPolicy(ListEntitiesForPolicyIterable.this.firstRequest);
            }
            return ListEntitiesForPolicyIterable.this.client.listEntitiesForPolicy((ListEntitiesForPolicyRequest)((Object)ListEntitiesForPolicyIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

