/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.AttachedPolicy;
import software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesResponse;

public class ListAttachedRolePoliciesIterable
implements SdkIterable<ListAttachedRolePoliciesResponse> {
    private final IAMClient client;
    private final ListAttachedRolePoliciesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAttachedRolePoliciesIterable(IAMClient client, ListAttachedRolePoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAttachedRolePoliciesResponseFetcher();
    }

    public Iterator<ListAttachedRolePoliciesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<AttachedPolicy> attachedPolicies() {
        Function<ListAttachedRolePoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.attachedPolicies() != null) {
                return response.attachedPolicies().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListAttachedRolePoliciesIterable resume(ListAttachedRolePoliciesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListAttachedRolePoliciesIterable(this.client, (ListAttachedRolePoliciesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListAttachedRolePoliciesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListAttachedRolePoliciesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListAttachedRolePoliciesResponseFetcher
    implements SyncPageFetcher<ListAttachedRolePoliciesResponse> {
        private ListAttachedRolePoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListAttachedRolePoliciesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListAttachedRolePoliciesResponse nextPage(ListAttachedRolePoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListAttachedRolePoliciesIterable.this.client.listAttachedRolePolicies(ListAttachedRolePoliciesIterable.this.firstRequest);
            }
            return ListAttachedRolePoliciesIterable.this.client.listAttachedRolePolicies((ListAttachedRolePoliciesRequest)((Object)ListAttachedRolePoliciesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

