/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.iam.IAMAsyncClient;
import software.amazon.awssdk.services.iam.model.AttachedPolicy;
import software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesResponse;

public class ListAttachedGroupPoliciesPublisher
implements SdkPublisher<ListAttachedGroupPoliciesResponse> {
    private final IAMAsyncClient client;
    private final ListAttachedGroupPoliciesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAttachedGroupPoliciesPublisher(IAMAsyncClient client, ListAttachedGroupPoliciesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAttachedGroupPoliciesPublisher(IAMAsyncClient client, ListAttachedGroupPoliciesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAttachedGroupPoliciesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAttachedGroupPoliciesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<AttachedPolicy> attachedPolicies() {
        Function<ListAttachedGroupPoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.attachedPolicies() != null) {
                return response.attachedPolicies().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new ListAttachedGroupPoliciesResponseFetcher(), getIterator, this.isLastPage);
    }

    public final ListAttachedGroupPoliciesPublisher resume(ListAttachedGroupPoliciesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListAttachedGroupPoliciesPublisher(this.client, (ListAttachedGroupPoliciesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListAttachedGroupPoliciesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListAttachedGroupPoliciesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListAttachedGroupPoliciesResponseFetcher
    implements AsyncPageFetcher<ListAttachedGroupPoliciesResponse> {
        private ListAttachedGroupPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListAttachedGroupPoliciesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public CompletableFuture<ListAttachedGroupPoliciesResponse> nextPage(ListAttachedGroupPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListAttachedGroupPoliciesPublisher.this.client.listAttachedGroupPolicies(ListAttachedGroupPoliciesPublisher.this.firstRequest);
            }
            return ListAttachedGroupPoliciesPublisher.this.client.listAttachedGroupPolicies((ListAttachedGroupPoliciesRequest)((Object)ListAttachedGroupPoliciesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

