/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsRequest;
import software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsResponse;
import software.amazon.awssdk.services.iam.model.GroupDetail;
import software.amazon.awssdk.services.iam.model.ManagedPolicyDetail;
import software.amazon.awssdk.services.iam.model.RoleDetail;
import software.amazon.awssdk.services.iam.model.UserDetail;

public class GetAccountAuthorizationDetailsIterable
implements SdkIterable<GetAccountAuthorizationDetailsResponse> {
    private final IAMClient client;
    private final GetAccountAuthorizationDetailsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetAccountAuthorizationDetailsIterable(IAMClient client, GetAccountAuthorizationDetailsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetAccountAuthorizationDetailsResponseFetcher();
    }

    public Iterator<GetAccountAuthorizationDetailsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<UserDetail> userDetailList() {
        Function<GetAccountAuthorizationDetailsResponse, Iterator> getIterator = response -> {
            if (response != null && response.userDetailList() != null) {
                return response.userDetailList().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final SdkIterable<GroupDetail> groupDetailList() {
        Function<GetAccountAuthorizationDetailsResponse, Iterator> getIterator = response -> {
            if (response != null && response.groupDetailList() != null) {
                return response.groupDetailList().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final SdkIterable<RoleDetail> roleDetailList() {
        Function<GetAccountAuthorizationDetailsResponse, Iterator> getIterator = response -> {
            if (response != null && response.roleDetailList() != null) {
                return response.roleDetailList().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final SdkIterable<ManagedPolicyDetail> policies() {
        Function<GetAccountAuthorizationDetailsResponse, Iterator> getIterator = response -> {
            if (response != null && response.policies() != null) {
                return response.policies().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final GetAccountAuthorizationDetailsIterable resume(GetAccountAuthorizationDetailsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetAccountAuthorizationDetailsIterable(this.client, (GetAccountAuthorizationDetailsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new GetAccountAuthorizationDetailsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetAccountAuthorizationDetailsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetAccountAuthorizationDetailsResponseFetcher
    implements SyncPageFetcher<GetAccountAuthorizationDetailsResponse> {
        private GetAccountAuthorizationDetailsResponseFetcher() {
        }

        public boolean hasNextPage(GetAccountAuthorizationDetailsResponse previousPage) {
            return previousPage.isTruncated();
        }

        public GetAccountAuthorizationDetailsResponse nextPage(GetAccountAuthorizationDetailsResponse previousPage) {
            if (previousPage == null) {
                return GetAccountAuthorizationDetailsIterable.this.client.getAccountAuthorizationDetails(GetAccountAuthorizationDetailsIterable.this.firstRequest);
            }
            return GetAccountAuthorizationDetailsIterable.this.client.getAccountAuthorizationDetails((GetAccountAuthorizationDetailsRequest)((Object)GetAccountAuthorizationDetailsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

