/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class User
implements ToCopyableBuilder<Builder, User> {
    private final String path;
    private final String userName;
    private final String userId;
    private final String arn;
    private final Instant createDate;
    private final Instant passwordLastUsed;

    private User(BuilderImpl builder) {
        this.path = builder.path;
        this.userName = builder.userName;
        this.userId = builder.userId;
        this.arn = builder.arn;
        this.createDate = builder.createDate;
        this.passwordLastUsed = builder.passwordLastUsed;
    }

    public String path() {
        return this.path;
    }

    public String userName() {
        return this.userName;
    }

    public String userId() {
        return this.userId;
    }

    public String arn() {
        return this.arn;
    }

    public Instant createDate() {
        return this.createDate;
    }

    public Instant passwordLastUsed() {
        return this.passwordLastUsed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.passwordLastUsed());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User)obj;
        return Objects.equals(this.path(), other.path()) && Objects.equals(this.userName(), other.userName()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createDate(), other.createDate()) && Objects.equals(this.passwordLastUsed(), other.passwordLastUsed());
    }

    public String toString() {
        return ToString.builder((String)"User").add("Path", (Object)this.path()).add("UserName", (Object)this.userName()).add("UserId", (Object)this.userId()).add("Arn", (Object)this.arn()).add("CreateDate", (Object)this.createDate()).add("PasswordLastUsed", (Object)this.passwordLastUsed()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Path": {
                return Optional.of(clazz.cast(this.path()));
            }
            case "UserName": {
                return Optional.of(clazz.cast(this.userName()));
            }
            case "UserId": {
                return Optional.of(clazz.cast(this.userId()));
            }
            case "Arn": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "CreateDate": {
                return Optional.of(clazz.cast(this.createDate()));
            }
            case "PasswordLastUsed": {
                return Optional.of(clazz.cast(this.passwordLastUsed()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String path;
        private String userName;
        private String userId;
        private String arn;
        private Instant createDate;
        private Instant passwordLastUsed;

        private BuilderImpl() {
        }

        private BuilderImpl(User model) {
            this.path(model.path);
            this.userName(model.userName);
            this.userId(model.userId);
            this.arn(model.arn);
            this.createDate(model.createDate);
            this.passwordLastUsed(model.passwordLastUsed);
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getUserId() {
            return this.userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final Instant getPasswordLastUsed() {
            return this.passwordLastUsed;
        }

        @Override
        public final Builder passwordLastUsed(Instant passwordLastUsed) {
            this.passwordLastUsed = passwordLastUsed;
            return this;
        }

        public final void setPasswordLastUsed(Instant passwordLastUsed) {
            this.passwordLastUsed = passwordLastUsed;
        }

        public User build() {
            return new User(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, User> {
        public Builder path(String var1);

        public Builder userName(String var1);

        public Builder userId(String var1);

        public Builder arn(String var1);

        public Builder createDate(Instant var1);

        public Builder passwordLastUsed(Instant var1);
    }
}

