/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.iam.model.IAMRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetInstanceProfileRequest
extends IAMRequest
implements ToCopyableBuilder<Builder, GetInstanceProfileRequest> {
    private final String instanceProfileName;

    private GetInstanceProfileRequest(BuilderImpl builder) {
        super(builder);
        this.instanceProfileName = builder.instanceProfileName;
    }

    public String instanceProfileName() {
        return this.instanceProfileName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceProfileName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstanceProfileRequest)) {
            return false;
        }
        GetInstanceProfileRequest other = (GetInstanceProfileRequest)((Object)obj);
        return Objects.equals(this.instanceProfileName(), other.instanceProfileName());
    }

    public String toString() {
        return ToString.builder((String)"GetInstanceProfileRequest").add("InstanceProfileName", (Object)this.instanceProfileName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceProfileName": {
                return Optional.of(clazz.cast(this.instanceProfileName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IAMRequest.BuilderImpl
    implements Builder {
        private String instanceProfileName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstanceProfileRequest model) {
            this.instanceProfileName(model.instanceProfileName);
        }

        public final String getInstanceProfileName() {
            return this.instanceProfileName;
        }

        @Override
        public final Builder instanceProfileName(String instanceProfileName) {
            this.instanceProfileName = instanceProfileName;
            return this;
        }

        public final void setInstanceProfileName(String instanceProfileName) {
            this.instanceProfileName = instanceProfileName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetInstanceProfileRequest build() {
            return new GetInstanceProfileRequest(this);
        }
    }

    public static interface Builder
    extends IAMRequest.Builder,
    CopyableBuilder<Builder, GetInstanceProfileRequest> {
        public Builder instanceProfileName(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

