/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.iam.model.GetUserPolicyRequest;

public class GetUserPolicyRequestMarshaller
implements Marshaller<Request<GetUserPolicyRequest>, GetUserPolicyRequest> {
    public Request<GetUserPolicyRequest> marshall(GetUserPolicyRequest getUserPolicyRequest) {
        if (getUserPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)getUserPolicyRequest, "IAMClient");
        request.addParameter("Action", "GetUserPolicy");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (getUserPolicyRequest.userName() != null) {
            request.addParameter("UserName", StringUtils.fromString((String)getUserPolicyRequest.userName()));
        }
        if (getUserPolicyRequest.policyName() != null) {
            request.addParameter("PolicyName", StringUtils.fromString((String)getUserPolicyRequest.policyName()));
        }
        return request;
    }
}

