/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.iam.model.CreateRoleRequest;

public class CreateRoleRequestMarshaller
implements Marshaller<Request<CreateRoleRequest>, CreateRoleRequest> {
    public Request<CreateRoleRequest> marshall(CreateRoleRequest createRoleRequest) {
        if (createRoleRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)createRoleRequest, "IAMClient");
        request.addParameter("Action", "CreateRole");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (createRoleRequest.path() != null) {
            request.addParameter("Path", StringUtils.fromString((String)createRoleRequest.path()));
        }
        if (createRoleRequest.roleName() != null) {
            request.addParameter("RoleName", StringUtils.fromString((String)createRoleRequest.roleName()));
        }
        if (createRoleRequest.assumeRolePolicyDocument() != null) {
            request.addParameter("AssumeRolePolicyDocument", StringUtils.fromString((String)createRoleRequest.assumeRolePolicyDocument()));
        }
        if (createRoleRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createRoleRequest.description()));
        }
        return request;
    }
}

