/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.ListRolePoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListRolePoliciesResponse;

public final class ListRolePoliciesPaginator
implements SdkIterable<ListRolePoliciesResponse> {
    private final IAMClient client;
    private final ListRolePoliciesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListRolePoliciesPaginator(IAMClient client, ListRolePoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListRolePoliciesResponseFetcher();
    }

    public Iterator<ListRolePoliciesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<String> policyNames() {
        Function<ListRolePoliciesResponse, Iterator> getIterator = response -> response != null ? response.policyNames().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListRolePoliciesResponseFetcher
    implements NextPageFetcher<ListRolePoliciesResponse> {
        private ListRolePoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListRolePoliciesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListRolePoliciesResponse nextPage(ListRolePoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListRolePoliciesPaginator.this.client.listRolePolicies(ListRolePoliciesPaginator.this.firstRequest);
            }
            return ListRolePoliciesPaginator.this.client.listRolePolicies((ListRolePoliciesRequest)((Object)ListRolePoliciesPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

