/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.AccessKeyMetadata;
import software.amazon.awssdk.services.iam.model.ListAccessKeysRequest;
import software.amazon.awssdk.services.iam.model.ListAccessKeysResponse;

public final class ListAccessKeysPaginator
implements SdkIterable<ListAccessKeysResponse> {
    private final IAMClient client;
    private final ListAccessKeysRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListAccessKeysPaginator(IAMClient client, ListAccessKeysRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAccessKeysResponseFetcher();
    }

    public Iterator<ListAccessKeysResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<AccessKeyMetadata> accessKeyMetadata() {
        Function<ListAccessKeysResponse, Iterator> getIterator = response -> response != null ? response.accessKeyMetadata().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListAccessKeysResponseFetcher
    implements NextPageFetcher<ListAccessKeysResponse> {
        private ListAccessKeysResponseFetcher() {
        }

        public boolean hasNextPage(ListAccessKeysResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListAccessKeysResponse nextPage(ListAccessKeysResponse previousPage) {
            if (previousPage == null) {
                return ListAccessKeysPaginator.this.client.listAccessKeys(ListAccessKeysPaginator.this.firstRequest);
            }
            return ListAccessKeysPaginator.this.client.listAccessKeys((ListAccessKeysRequest)((Object)ListAccessKeysPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

