/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.iam.model.IAMResponse;
import software.amazon.awssdk.services.iam.model._clientIDListTypeCopier;
import software.amazon.awssdk.services.iam.model._thumbprintListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetOpenIDConnectProviderResponse
extends IAMResponse
implements ToCopyableBuilder<Builder, GetOpenIDConnectProviderResponse> {
    private final String url;
    private final List<String> clientIDList;
    private final List<String> thumbprintList;
    private final Instant createDate;

    private GetOpenIDConnectProviderResponse(BuilderImpl builder) {
        super(builder);
        this.url = builder.url;
        this.clientIDList = builder.clientIDList;
        this.thumbprintList = builder.thumbprintList;
        this.createDate = builder.createDate;
    }

    public String url() {
        return this.url;
    }

    public List<String> clientIDList() {
        return this.clientIDList;
    }

    public List<String> thumbprintList() {
        return this.thumbprintList;
    }

    public Instant createDate() {
        return this.createDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientIDList());
        hashCode = 31 * hashCode + Objects.hashCode(this.thumbprintList());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOpenIDConnectProviderResponse)) {
            return false;
        }
        GetOpenIDConnectProviderResponse other = (GetOpenIDConnectProviderResponse)((Object)obj);
        return Objects.equals(this.url(), other.url()) && Objects.equals(this.clientIDList(), other.clientIDList()) && Objects.equals(this.thumbprintList(), other.thumbprintList()) && Objects.equals(this.createDate(), other.createDate());
    }

    public String toString() {
        return ToString.builder((String)"GetOpenIDConnectProviderResponse").add("Url", (Object)this.url()).add("ClientIDList", this.clientIDList()).add("ThumbprintList", this.thumbprintList()).add("CreateDate", (Object)this.createDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Url": {
                return Optional.of(clazz.cast(this.url()));
            }
            case "ClientIDList": {
                return Optional.of(clazz.cast(this.clientIDList()));
            }
            case "ThumbprintList": {
                return Optional.of(clazz.cast(this.thumbprintList()));
            }
            case "CreateDate": {
                return Optional.of(clazz.cast(this.createDate()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IAMResponse.BuilderImpl
    implements Builder {
        private String url;
        private List<String> clientIDList;
        private List<String> thumbprintList;
        private Instant createDate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOpenIDConnectProviderResponse model) {
            this.url(model.url);
            this.clientIDList(model.clientIDList);
            this.thumbprintList(model.thumbprintList);
            this.createDate(model.createDate);
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final Collection<String> getClientIDList() {
            return this.clientIDList;
        }

        @Override
        public final Builder clientIDList(Collection<String> clientIDList) {
            this.clientIDList = _clientIDListTypeCopier.copy(clientIDList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientIDList(String ... clientIDList) {
            this.clientIDList(Arrays.asList(clientIDList));
            return this;
        }

        public final void setClientIDList(Collection<String> clientIDList) {
            this.clientIDList = _clientIDListTypeCopier.copy(clientIDList);
        }

        public final Collection<String> getThumbprintList() {
            return this.thumbprintList;
        }

        @Override
        public final Builder thumbprintList(Collection<String> thumbprintList) {
            this.thumbprintList = _thumbprintListTypeCopier.copy(thumbprintList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thumbprintList(String ... thumbprintList) {
            this.thumbprintList(Arrays.asList(thumbprintList));
            return this;
        }

        public final void setThumbprintList(Collection<String> thumbprintList) {
            this.thumbprintList = _thumbprintListTypeCopier.copy(thumbprintList);
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        @Override
        public GetOpenIDConnectProviderResponse build() {
            return new GetOpenIDConnectProviderResponse(this);
        }
    }

    public static interface Builder
    extends IAMResponse.Builder,
    CopyableBuilder<Builder, GetOpenIDConnectProviderResponse> {
        public Builder url(String var1);

        public Builder clientIDList(Collection<String> var1);

        public Builder clientIDList(String ... var1);

        public Builder thumbprintList(Collection<String> var1);

        public Builder thumbprintList(String ... var1);

        public Builder createDate(Instant var1);
    }
}

