/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.iam.model.IAMRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteServiceSpecificCredentialRequest
extends IAMRequest
implements ToCopyableBuilder<Builder, DeleteServiceSpecificCredentialRequest> {
    private final String userName;
    private final String serviceSpecificCredentialId;

    private DeleteServiceSpecificCredentialRequest(BuilderImpl builder) {
        super(builder);
        this.userName = builder.userName;
        this.serviceSpecificCredentialId = builder.serviceSpecificCredentialId;
    }

    public String userName() {
        return this.userName;
    }

    public String serviceSpecificCredentialId() {
        return this.serviceSpecificCredentialId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceSpecificCredentialId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteServiceSpecificCredentialRequest)) {
            return false;
        }
        DeleteServiceSpecificCredentialRequest other = (DeleteServiceSpecificCredentialRequest)((Object)obj);
        return Objects.equals(this.userName(), other.userName()) && Objects.equals(this.serviceSpecificCredentialId(), other.serviceSpecificCredentialId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.userName() != null) {
            sb.append("UserName: ").append(this.userName()).append(",");
        }
        if (this.serviceSpecificCredentialId() != null) {
            sb.append("ServiceSpecificCredentialId: ").append(this.serviceSpecificCredentialId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.of(clazz.cast(this.userName()));
            }
            case "ServiceSpecificCredentialId": {
                return Optional.of(clazz.cast(this.serviceSpecificCredentialId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IAMRequest.BuilderImpl
    implements Builder {
        private String userName;
        private String serviceSpecificCredentialId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteServiceSpecificCredentialRequest model) {
            this.userName(model.userName);
            this.serviceSpecificCredentialId(model.serviceSpecificCredentialId);
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getServiceSpecificCredentialId() {
            return this.serviceSpecificCredentialId;
        }

        @Override
        public final Builder serviceSpecificCredentialId(String serviceSpecificCredentialId) {
            this.serviceSpecificCredentialId = serviceSpecificCredentialId;
            return this;
        }

        public final void setServiceSpecificCredentialId(String serviceSpecificCredentialId) {
            this.serviceSpecificCredentialId = serviceSpecificCredentialId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteServiceSpecificCredentialRequest build() {
            return new DeleteServiceSpecificCredentialRequest(this);
        }
    }

    public static interface Builder
    extends IAMRequest.Builder,
    CopyableBuilder<Builder, DeleteServiceSpecificCredentialRequest> {
        public Builder userName(String var1);

        public Builder serviceSpecificCredentialId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

