/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.iam.model.IAMRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AddClientIDToOpenIDConnectProviderRequest
extends IAMRequest
implements ToCopyableBuilder<Builder, AddClientIDToOpenIDConnectProviderRequest> {
    private final String openIDConnectProviderArn;
    private final String clientID;

    private AddClientIDToOpenIDConnectProviderRequest(BuilderImpl builder) {
        super(builder);
        this.openIDConnectProviderArn = builder.openIDConnectProviderArn;
        this.clientID = builder.clientID;
    }

    public String openIDConnectProviderArn() {
        return this.openIDConnectProviderArn;
    }

    public String clientID() {
        return this.clientID;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.openIDConnectProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientID());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddClientIDToOpenIDConnectProviderRequest)) {
            return false;
        }
        AddClientIDToOpenIDConnectProviderRequest other = (AddClientIDToOpenIDConnectProviderRequest)((Object)obj);
        return Objects.equals(this.openIDConnectProviderArn(), other.openIDConnectProviderArn()) && Objects.equals(this.clientID(), other.clientID());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.openIDConnectProviderArn() != null) {
            sb.append("OpenIDConnectProviderArn: ").append(this.openIDConnectProviderArn()).append(",");
        }
        if (this.clientID() != null) {
            sb.append("ClientID: ").append(this.clientID()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OpenIDConnectProviderArn": {
                return Optional.of(clazz.cast(this.openIDConnectProviderArn()));
            }
            case "ClientID": {
                return Optional.of(clazz.cast(this.clientID()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IAMRequest.BuilderImpl
    implements Builder {
        private String openIDConnectProviderArn;
        private String clientID;

        private BuilderImpl() {
        }

        private BuilderImpl(AddClientIDToOpenIDConnectProviderRequest model) {
            this.openIDConnectProviderArn(model.openIDConnectProviderArn);
            this.clientID(model.clientID);
        }

        public final String getOpenIDConnectProviderArn() {
            return this.openIDConnectProviderArn;
        }

        @Override
        public final Builder openIDConnectProviderArn(String openIDConnectProviderArn) {
            this.openIDConnectProviderArn = openIDConnectProviderArn;
            return this;
        }

        public final void setOpenIDConnectProviderArn(String openIDConnectProviderArn) {
            this.openIDConnectProviderArn = openIDConnectProviderArn;
        }

        public final String getClientID() {
            return this.clientID;
        }

        @Override
        public final Builder clientID(String clientID) {
            this.clientID = clientID;
            return this;
        }

        public final void setClientID(String clientID) {
            this.clientID = clientID;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public AddClientIDToOpenIDConnectProviderRequest build() {
            return new AddClientIDToOpenIDConnectProviderRequest(this);
        }
    }

    public static interface Builder
    extends IAMRequest.Builder,
    CopyableBuilder<Builder, AddClientIDToOpenIDConnectProviderRequest> {
        public Builder openIDConnectProviderArn(String var1);

        public Builder clientID(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

