/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.iam.model.UploadSSHPublicKeyRequest;

public class UploadSSHPublicKeyRequestMarshaller
implements Marshaller<Request<UploadSSHPublicKeyRequest>, UploadSSHPublicKeyRequest> {
    public Request<UploadSSHPublicKeyRequest> marshall(UploadSSHPublicKeyRequest uploadSSHPublicKeyRequest) {
        if (uploadSSHPublicKeyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)uploadSSHPublicKeyRequest, "IAMClient");
        request.addParameter("Action", "UploadSSHPublicKey");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (uploadSSHPublicKeyRequest.userName() != null) {
            request.addParameter("UserName", StringUtils.fromString((String)uploadSSHPublicKeyRequest.userName()));
        }
        if (uploadSSHPublicKeyRequest.sshPublicKeyBody() != null) {
            request.addParameter("SSHPublicKeyBody", StringUtils.fromString((String)uploadSSHPublicKeyRequest.sshPublicKeyBody()));
        }
        return request;
    }
}

