/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.iam.model.PutGroupPolicyRequest;

public class PutGroupPolicyRequestMarshaller
implements Marshaller<Request<PutGroupPolicyRequest>, PutGroupPolicyRequest> {
    public Request<PutGroupPolicyRequest> marshall(PutGroupPolicyRequest putGroupPolicyRequest) {
        if (putGroupPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putGroupPolicyRequest, "IAMClient");
        request.addParameter("Action", "PutGroupPolicy");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (putGroupPolicyRequest.groupName() != null) {
            request.addParameter("GroupName", StringUtils.fromString((String)putGroupPolicyRequest.groupName()));
        }
        if (putGroupPolicyRequest.policyName() != null) {
            request.addParameter("PolicyName", StringUtils.fromString((String)putGroupPolicyRequest.policyName()));
        }
        if (putGroupPolicyRequest.policyDocument() != null) {
            request.addParameter("PolicyDocument", StringUtils.fromString((String)putGroupPolicyRequest.policyDocument()));
        }
        return request;
    }
}

