/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsRequest;

public class GetAccountAuthorizationDetailsRequestMarshaller
implements Marshaller<Request<GetAccountAuthorizationDetailsRequest>, GetAccountAuthorizationDetailsRequest> {
    public Request<GetAccountAuthorizationDetailsRequest> marshall(GetAccountAuthorizationDetailsRequest getAccountAuthorizationDetailsRequest) {
        if (getAccountAuthorizationDetailsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getAccountAuthorizationDetailsRequest, "IAMClient");
        request.addParameter("Action", "GetAccountAuthorizationDetails");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> filterList = getAccountAuthorizationDetailsRequest.filterStrings();
        if (filterList != null) {
            if (!filterList.isEmpty()) {
                int filterListIndex = 1;
                for (String filterListValue : filterList) {
                    if (filterListValue != null) {
                        request.addParameter("Filter.member." + filterListIndex, StringUtils.fromString((String)filterListValue));
                    }
                    ++filterListIndex;
                }
            } else {
                request.addParameter("Filter", "");
            }
        }
        if (getAccountAuthorizationDetailsRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger((Integer)getAccountAuthorizationDetailsRequest.maxItems()));
        }
        if (getAccountAuthorizationDetailsRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)getAccountAuthorizationDetailsRequest.marker()));
        }
        return request;
    }
}

