/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.iam.model.CreateGroupRequest;

public class CreateGroupRequestMarshaller
implements Marshaller<Request<CreateGroupRequest>, CreateGroupRequest> {
    public Request<CreateGroupRequest> marshall(CreateGroupRequest createGroupRequest) {
        if (createGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createGroupRequest, "IAMClient");
        request.addParameter("Action", "CreateGroup");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (createGroupRequest.path() != null) {
            request.addParameter("Path", StringUtils.fromString((String)createGroupRequest.path()));
        }
        if (createGroupRequest.groupName() != null) {
            request.addParameter("GroupName", StringUtils.fromString((String)createGroupRequest.groupName()));
        }
        return request;
    }
}

