/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.ListVirtualMFADevicesRequest;
import software.amazon.awssdk.services.iam.model.ListVirtualMFADevicesResponse;
import software.amazon.awssdk.services.iam.model.VirtualMFADevice;

public final class ListVirtualMFADevicesPaginator
implements SdkIterable<ListVirtualMFADevicesResponse> {
    private final IAMClient client;
    private final ListVirtualMFADevicesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListVirtualMFADevicesPaginator(IAMClient client, ListVirtualMFADevicesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListVirtualMFADevicesResponseFetcher();
    }

    public Iterator<ListVirtualMFADevicesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<VirtualMFADevice> virtualMFADevices() {
        Function<ListVirtualMFADevicesResponse, Iterator> getIterator = response -> response != null ? response.virtualMFADevices().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListVirtualMFADevicesResponseFetcher
    implements NextPageFetcher<ListVirtualMFADevicesResponse> {
        private ListVirtualMFADevicesResponseFetcher() {
        }

        public boolean hasNextPage(ListVirtualMFADevicesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListVirtualMFADevicesResponse nextPage(ListVirtualMFADevicesResponse previousPage) {
            if (previousPage == null) {
                return ListVirtualMFADevicesPaginator.this.client.listVirtualMFADevices(ListVirtualMFADevicesPaginator.this.firstRequest);
            }
            return ListVirtualMFADevicesPaginator.this.client.listVirtualMFADevices((ListVirtualMFADevicesRequest)((Object)ListVirtualMFADevicesPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

