/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.ListUserPoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListUserPoliciesResponse;

public final class ListUserPoliciesPaginator
implements SdkIterable<ListUserPoliciesResponse> {
    private final IAMClient client;
    private final ListUserPoliciesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListUserPoliciesPaginator(IAMClient client, ListUserPoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListUserPoliciesResponseFetcher();
    }

    public Iterator<ListUserPoliciesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<String> policyNames() {
        Function<ListUserPoliciesResponse, Iterator> getIterator = response -> response != null ? response.policyNames().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListUserPoliciesResponseFetcher
    implements NextPageFetcher<ListUserPoliciesResponse> {
        private ListUserPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListUserPoliciesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListUserPoliciesResponse nextPage(ListUserPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListUserPoliciesPaginator.this.client.listUserPolicies(ListUserPoliciesPaginator.this.firstRequest);
            }
            return ListUserPoliciesPaginator.this.client.listUserPolicies((ListUserPoliciesRequest)((Object)ListUserPoliciesPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

