/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.ListSSHPublicKeysRequest;
import software.amazon.awssdk.services.iam.model.ListSSHPublicKeysResponse;
import software.amazon.awssdk.services.iam.model.SSHPublicKeyMetadata;

public final class ListSSHPublicKeysPaginator
implements SdkIterable<ListSSHPublicKeysResponse> {
    private final IAMClient client;
    private final ListSSHPublicKeysRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListSSHPublicKeysPaginator(IAMClient client, ListSSHPublicKeysRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSSHPublicKeysResponseFetcher();
    }

    public Iterator<ListSSHPublicKeysResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<SSHPublicKeyMetadata> sshPublicKeys() {
        Function<ListSSHPublicKeysResponse, Iterator> getIterator = response -> response != null ? response.sshPublicKeys().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListSSHPublicKeysResponseFetcher
    implements NextPageFetcher<ListSSHPublicKeysResponse> {
        private ListSSHPublicKeysResponseFetcher() {
        }

        public boolean hasNextPage(ListSSHPublicKeysResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListSSHPublicKeysResponse nextPage(ListSSHPublicKeysResponse previousPage) {
            if (previousPage == null) {
                return ListSSHPublicKeysPaginator.this.client.listSSHPublicKeys(ListSSHPublicKeysPaginator.this.firstRequest);
            }
            return ListSSHPublicKeysPaginator.this.client.listSSHPublicKeys((ListSSHPublicKeysRequest)((Object)ListSSHPublicKeysPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

