/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.ListPolicyVersionsRequest;
import software.amazon.awssdk.services.iam.model.ListPolicyVersionsResponse;
import software.amazon.awssdk.services.iam.model.PolicyVersion;

public final class ListPolicyVersionsPaginator
implements SdkIterable<ListPolicyVersionsResponse> {
    private final IAMClient client;
    private final ListPolicyVersionsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListPolicyVersionsPaginator(IAMClient client, ListPolicyVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPolicyVersionsResponseFetcher();
    }

    public Iterator<ListPolicyVersionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<PolicyVersion> versions() {
        Function<ListPolicyVersionsResponse, Iterator> getIterator = response -> response != null ? response.versions().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListPolicyVersionsResponseFetcher
    implements NextPageFetcher<ListPolicyVersionsResponse> {
        private ListPolicyVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListPolicyVersionsResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListPolicyVersionsResponse nextPage(ListPolicyVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListPolicyVersionsPaginator.this.client.listPolicyVersions(ListPolicyVersionsPaginator.this.firstRequest);
            }
            return ListPolicyVersionsPaginator.this.client.listPolicyVersions((ListPolicyVersionsRequest)((Object)ListPolicyVersionsPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

