/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyRequest;
import software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyResponse;
import software.amazon.awssdk.services.iam.model.PolicyGroup;
import software.amazon.awssdk.services.iam.model.PolicyRole;
import software.amazon.awssdk.services.iam.model.PolicyUser;

public final class ListEntitiesForPolicyPaginator
implements SdkIterable<ListEntitiesForPolicyResponse> {
    private final IAMClient client;
    private final ListEntitiesForPolicyRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListEntitiesForPolicyPaginator(IAMClient client, ListEntitiesForPolicyRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListEntitiesForPolicyResponseFetcher();
    }

    public Iterator<ListEntitiesForPolicyResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<PolicyGroup> policyGroups() {
        Function<ListEntitiesForPolicyResponse, Iterator> getIterator = response -> response != null ? response.policyGroups().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public SdkIterable<PolicyUser> policyUsers() {
        Function<ListEntitiesForPolicyResponse, Iterator> getIterator = response -> response != null ? response.policyUsers().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public SdkIterable<PolicyRole> policyRoles() {
        Function<ListEntitiesForPolicyResponse, Iterator> getIterator = response -> response != null ? response.policyRoles().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListEntitiesForPolicyResponseFetcher
    implements NextPageFetcher<ListEntitiesForPolicyResponse> {
        private ListEntitiesForPolicyResponseFetcher() {
        }

        public boolean hasNextPage(ListEntitiesForPolicyResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListEntitiesForPolicyResponse nextPage(ListEntitiesForPolicyResponse previousPage) {
            if (previousPage == null) {
                return ListEntitiesForPolicyPaginator.this.client.listEntitiesForPolicy(ListEntitiesForPolicyPaginator.this.firstRequest);
            }
            return ListEntitiesForPolicyPaginator.this.client.listEntitiesForPolicy((ListEntitiesForPolicyRequest)((Object)ListEntitiesForPolicyPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

