/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.AttachedPolicy;
import software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesResponse;

public final class ListAttachedRolePoliciesPaginator
implements SdkIterable<ListAttachedRolePoliciesResponse> {
    private final IAMClient client;
    private final ListAttachedRolePoliciesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListAttachedRolePoliciesPaginator(IAMClient client, ListAttachedRolePoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAttachedRolePoliciesResponseFetcher();
    }

    public Iterator<ListAttachedRolePoliciesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<AttachedPolicy> attachedPolicies() {
        Function<ListAttachedRolePoliciesResponse, Iterator> getIterator = response -> response != null ? response.attachedPolicies().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListAttachedRolePoliciesResponseFetcher
    implements NextPageFetcher<ListAttachedRolePoliciesResponse> {
        private ListAttachedRolePoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListAttachedRolePoliciesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListAttachedRolePoliciesResponse nextPage(ListAttachedRolePoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListAttachedRolePoliciesPaginator.this.client.listAttachedRolePolicies(ListAttachedRolePoliciesPaginator.this.firstRequest);
            }
            return ListAttachedRolePoliciesPaginator.this.client.listAttachedRolePolicies((ListAttachedRolePoliciesRequest)((Object)ListAttachedRolePoliciesPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

