/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.iam.model.StatusType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ServiceSpecificCredential
implements ToCopyableBuilder<Builder, ServiceSpecificCredential> {
    private final Instant createDate;
    private final String serviceName;
    private final String serviceUserName;
    private final String servicePassword;
    private final String serviceSpecificCredentialId;
    private final String userName;
    private final String status;

    private ServiceSpecificCredential(BuilderImpl builder) {
        this.createDate = builder.createDate;
        this.serviceName = builder.serviceName;
        this.serviceUserName = builder.serviceUserName;
        this.servicePassword = builder.servicePassword;
        this.serviceSpecificCredentialId = builder.serviceSpecificCredentialId;
        this.userName = builder.userName;
        this.status = builder.status;
    }

    public Instant createDate() {
        return this.createDate;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public String serviceUserName() {
        return this.serviceUserName;
    }

    public String servicePassword() {
        return this.servicePassword;
    }

    public String serviceSpecificCredentialId() {
        return this.serviceSpecificCredentialId;
    }

    public String userName() {
        return this.userName;
    }

    public StatusType status() {
        return StatusType.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceUserName());
        hashCode = 31 * hashCode + Objects.hashCode(this.servicePassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceSpecificCredentialId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceSpecificCredential)) {
            return false;
        }
        ServiceSpecificCredential other = (ServiceSpecificCredential)obj;
        return Objects.equals(this.createDate(), other.createDate()) && Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.serviceUserName(), other.serviceUserName()) && Objects.equals(this.servicePassword(), other.servicePassword()) && Objects.equals(this.serviceSpecificCredentialId(), other.serviceSpecificCredentialId()) && Objects.equals(this.userName(), other.userName()) && Objects.equals(this.statusString(), other.statusString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.createDate() != null) {
            sb.append("CreateDate: ").append(this.createDate()).append(",");
        }
        if (this.serviceName() != null) {
            sb.append("ServiceName: ").append(this.serviceName()).append(",");
        }
        if (this.serviceUserName() != null) {
            sb.append("ServiceUserName: ").append(this.serviceUserName()).append(",");
        }
        if (this.servicePassword() != null) {
            sb.append("ServicePassword: ").append(this.servicePassword()).append(",");
        }
        if (this.serviceSpecificCredentialId() != null) {
            sb.append("ServiceSpecificCredentialId: ").append(this.serviceSpecificCredentialId()).append(",");
        }
        if (this.userName() != null) {
            sb.append("UserName: ").append(this.userName()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreateDate": {
                return Optional.of(clazz.cast(this.createDate()));
            }
            case "ServiceName": {
                return Optional.of(clazz.cast(this.serviceName()));
            }
            case "ServiceUserName": {
                return Optional.of(clazz.cast(this.serviceUserName()));
            }
            case "ServicePassword": {
                return Optional.of(clazz.cast(this.servicePassword()));
            }
            case "ServiceSpecificCredentialId": {
                return Optional.of(clazz.cast(this.serviceSpecificCredentialId()));
            }
            case "UserName": {
                return Optional.of(clazz.cast(this.userName()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createDate;
        private String serviceName;
        private String serviceUserName;
        private String servicePassword;
        private String serviceSpecificCredentialId;
        private String userName;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceSpecificCredential model) {
            this.createDate(model.createDate);
            this.serviceName(model.serviceName);
            this.serviceUserName(model.serviceUserName);
            this.servicePassword(model.servicePassword);
            this.serviceSpecificCredentialId(model.serviceSpecificCredentialId);
            this.userName(model.userName);
            this.status(model.status);
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final String getServiceUserName() {
            return this.serviceUserName;
        }

        @Override
        public final Builder serviceUserName(String serviceUserName) {
            this.serviceUserName = serviceUserName;
            return this;
        }

        public final void setServiceUserName(String serviceUserName) {
            this.serviceUserName = serviceUserName;
        }

        public final String getServicePassword() {
            return this.servicePassword;
        }

        @Override
        public final Builder servicePassword(String servicePassword) {
            this.servicePassword = servicePassword;
            return this;
        }

        public final void setServicePassword(String servicePassword) {
            this.servicePassword = servicePassword;
        }

        public final String getServiceSpecificCredentialId() {
            return this.serviceSpecificCredentialId;
        }

        @Override
        public final Builder serviceSpecificCredentialId(String serviceSpecificCredentialId) {
            this.serviceSpecificCredentialId = serviceSpecificCredentialId;
            return this;
        }

        public final void setServiceSpecificCredentialId(String serviceSpecificCredentialId) {
            this.serviceSpecificCredentialId = serviceSpecificCredentialId;
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StatusType status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public ServiceSpecificCredential build() {
            return new ServiceSpecificCredential(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ServiceSpecificCredential> {
        public Builder createDate(Instant var1);

        public Builder serviceName(String var1);

        public Builder serviceUserName(String var1);

        public Builder servicePassword(String var1);

        public Builder serviceSpecificCredentialId(String var1);

        public Builder userName(String var1);

        public Builder status(String var1);

        public Builder status(StatusType var1);
    }
}

