/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.iam.model.AssignmentStatusType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListVirtualMFADevicesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListVirtualMFADevicesRequest> {
    private final String assignmentStatus;
    private final String marker;
    private final Integer maxItems;

    private ListVirtualMFADevicesRequest(BuilderImpl builder) {
        this.assignmentStatus = builder.assignmentStatus;
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
    }

    public AssignmentStatusType assignmentStatus() {
        return AssignmentStatusType.fromValue(this.assignmentStatus);
    }

    public String assignmentStatusString() {
        return this.assignmentStatus;
    }

    public String marker() {
        return this.marker;
    }

    public Integer maxItems() {
        return this.maxItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.assignmentStatusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVirtualMFADevicesRequest)) {
            return false;
        }
        ListVirtualMFADevicesRequest other = (ListVirtualMFADevicesRequest)((Object)obj);
        return Objects.equals(this.assignmentStatusString(), other.assignmentStatusString()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.assignmentStatusString() != null) {
            sb.append("AssignmentStatus: ").append(this.assignmentStatusString()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.maxItems() != null) {
            sb.append("MaxItems: ").append(this.maxItems()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssignmentStatus": {
                return Optional.of(clazz.cast(this.assignmentStatusString()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "MaxItems": {
                return Optional.of(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String assignmentStatus;
        private String marker;
        private Integer maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVirtualMFADevicesRequest model) {
            this.assignmentStatus(model.assignmentStatus);
            this.marker(model.marker);
            this.maxItems(model.maxItems);
        }

        public final String getAssignmentStatus() {
            return this.assignmentStatus;
        }

        @Override
        public final Builder assignmentStatus(String assignmentStatus) {
            this.assignmentStatus = assignmentStatus;
            return this;
        }

        @Override
        public final Builder assignmentStatus(AssignmentStatusType assignmentStatus) {
            this.assignmentStatus(assignmentStatus.toString());
            return this;
        }

        public final void setAssignmentStatus(String assignmentStatus) {
            this.assignmentStatus = assignmentStatus;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        public ListVirtualMFADevicesRequest build() {
            return new ListVirtualMFADevicesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListVirtualMFADevicesRequest> {
        public Builder assignmentStatus(String var1);

        public Builder assignmentStatus(AssignmentStatusType var1);

        public Builder marker(String var1);

        public Builder maxItems(Integer var1);
    }
}

