/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.iam.model.SAMLProviderListEntry;
import software.amazon.awssdk.services.iam.model.SAMLProviderListTypeCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListSAMLProvidersResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListSAMLProvidersResponse> {
    private final List<SAMLProviderListEntry> samlProviderList;

    private ListSAMLProvidersResponse(BuilderImpl builder) {
        this.samlProviderList = builder.samlProviderList;
    }

    public List<SAMLProviderListEntry> samlProviderList() {
        return this.samlProviderList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.samlProviderList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSAMLProvidersResponse)) {
            return false;
        }
        ListSAMLProvidersResponse other = (ListSAMLProvidersResponse)((Object)obj);
        return Objects.equals(this.samlProviderList(), other.samlProviderList());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.samlProviderList() != null) {
            sb.append("SAMLProviderList: ").append(this.samlProviderList()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SAMLProviderList": {
                return Optional.of(clazz.cast(this.samlProviderList()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<SAMLProviderListEntry> samlProviderList;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSAMLProvidersResponse model) {
            this.samlProviderList(model.samlProviderList);
        }

        public final Collection<SAMLProviderListEntry.Builder> getSAMLProviderList() {
            return this.samlProviderList != null ? (Collection)this.samlProviderList.stream().map(SAMLProviderListEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder samlProviderList(Collection<SAMLProviderListEntry> samlProviderList) {
            this.samlProviderList = SAMLProviderListTypeCopier.copy(samlProviderList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder samlProviderList(SAMLProviderListEntry ... samlProviderList) {
            this.samlProviderList(Arrays.asList(samlProviderList));
            return this;
        }

        public final void setSAMLProviderList(Collection<SAMLProviderListEntry.BuilderImpl> samlProviderList) {
            this.samlProviderList = SAMLProviderListTypeCopier.copyFromBuilder(samlProviderList);
        }

        public ListSAMLProvidersResponse build() {
            return new ListSAMLProvidersResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListSAMLProvidersResponse> {
        public Builder samlProviderList(Collection<SAMLProviderListEntry> var1);

        public Builder samlProviderList(SAMLProviderListEntry ... var1);
    }
}

