/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.iam.model.InstanceProfile;
import software.amazon.awssdk.services.iam.model._instanceProfileListTypeCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListInstanceProfilesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListInstanceProfilesResponse> {
    private final List<InstanceProfile> instanceProfiles;
    private final Boolean isTruncated;
    private final String marker;

    private ListInstanceProfilesResponse(BuilderImpl builder) {
        this.instanceProfiles = builder.instanceProfiles;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    public List<InstanceProfile> instanceProfiles() {
        return this.instanceProfiles;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceProfiles());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInstanceProfilesResponse)) {
            return false;
        }
        ListInstanceProfilesResponse other = (ListInstanceProfilesResponse)((Object)obj);
        return Objects.equals(this.instanceProfiles(), other.instanceProfiles()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instanceProfiles() != null) {
            sb.append("InstanceProfiles: ").append(this.instanceProfiles()).append(",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: ").append(this.isTruncated()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceProfiles": {
                return Optional.of(clazz.cast(this.instanceProfiles()));
            }
            case "IsTruncated": {
                return Optional.of(clazz.cast(this.isTruncated()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<InstanceProfile> instanceProfiles;
        private Boolean isTruncated;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInstanceProfilesResponse model) {
            this.instanceProfiles(model.instanceProfiles);
            this.isTruncated(model.isTruncated);
            this.marker(model.marker);
        }

        public final Collection<InstanceProfile.Builder> getInstanceProfiles() {
            return this.instanceProfiles != null ? (Collection)this.instanceProfiles.stream().map(InstanceProfile::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceProfiles(Collection<InstanceProfile> instanceProfiles) {
            this.instanceProfiles = _instanceProfileListTypeCopier.copy(instanceProfiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceProfiles(InstanceProfile ... instanceProfiles) {
            this.instanceProfiles(Arrays.asList(instanceProfiles));
            return this;
        }

        public final void setInstanceProfiles(Collection<InstanceProfile.BuilderImpl> instanceProfiles) {
            this.instanceProfiles = _instanceProfileListTypeCopier.copyFromBuilder(instanceProfiles);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public ListInstanceProfilesResponse build() {
            return new ListInstanceProfilesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListInstanceProfilesResponse> {
        public Builder instanceProfiles(Collection<InstanceProfile> var1);

        public Builder instanceProfiles(InstanceProfile ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);
    }
}

