/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.iam.model.Role;
import software.amazon.awssdk.services.iam.model._roleListTypeCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceProfile
implements ToCopyableBuilder<Builder, InstanceProfile> {
    private final String path;
    private final String instanceProfileName;
    private final String instanceProfileId;
    private final String arn;
    private final Instant createDate;
    private final List<Role> roles;

    private InstanceProfile(BuilderImpl builder) {
        this.path = builder.path;
        this.instanceProfileName = builder.instanceProfileName;
        this.instanceProfileId = builder.instanceProfileId;
        this.arn = builder.arn;
        this.createDate = builder.createDate;
        this.roles = builder.roles;
    }

    public String path() {
        return this.path;
    }

    public String instanceProfileName() {
        return this.instanceProfileName;
    }

    public String instanceProfileId() {
        return this.instanceProfileId;
    }

    public String arn() {
        return this.arn;
    }

    public Instant createDate() {
        return this.createDate;
    }

    public List<Role> roles() {
        return this.roles;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.roles());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceProfile)) {
            return false;
        }
        InstanceProfile other = (InstanceProfile)obj;
        return Objects.equals(this.path(), other.path()) && Objects.equals(this.instanceProfileName(), other.instanceProfileName()) && Objects.equals(this.instanceProfileId(), other.instanceProfileId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createDate(), other.createDate()) && Objects.equals(this.roles(), other.roles());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.path() != null) {
            sb.append("Path: ").append(this.path()).append(",");
        }
        if (this.instanceProfileName() != null) {
            sb.append("InstanceProfileName: ").append(this.instanceProfileName()).append(",");
        }
        if (this.instanceProfileId() != null) {
            sb.append("InstanceProfileId: ").append(this.instanceProfileId()).append(",");
        }
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.createDate() != null) {
            sb.append("CreateDate: ").append(this.createDate()).append(",");
        }
        if (this.roles() != null) {
            sb.append("Roles: ").append(this.roles()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Path": {
                return Optional.of(clazz.cast(this.path()));
            }
            case "InstanceProfileName": {
                return Optional.of(clazz.cast(this.instanceProfileName()));
            }
            case "InstanceProfileId": {
                return Optional.of(clazz.cast(this.instanceProfileId()));
            }
            case "Arn": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "CreateDate": {
                return Optional.of(clazz.cast(this.createDate()));
            }
            case "Roles": {
                return Optional.of(clazz.cast(this.roles()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String path;
        private String instanceProfileName;
        private String instanceProfileId;
        private String arn;
        private Instant createDate;
        private List<Role> roles;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceProfile model) {
            this.path(model.path);
            this.instanceProfileName(model.instanceProfileName);
            this.instanceProfileId(model.instanceProfileId);
            this.arn(model.arn);
            this.createDate(model.createDate);
            this.roles(model.roles);
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getInstanceProfileName() {
            return this.instanceProfileName;
        }

        @Override
        public final Builder instanceProfileName(String instanceProfileName) {
            this.instanceProfileName = instanceProfileName;
            return this;
        }

        public final void setInstanceProfileName(String instanceProfileName) {
            this.instanceProfileName = instanceProfileName;
        }

        public final String getInstanceProfileId() {
            return this.instanceProfileId;
        }

        @Override
        public final Builder instanceProfileId(String instanceProfileId) {
            this.instanceProfileId = instanceProfileId;
            return this;
        }

        public final void setInstanceProfileId(String instanceProfileId) {
            this.instanceProfileId = instanceProfileId;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final Collection<Role.Builder> getRoles() {
            return this.roles != null ? (Collection)this.roles.stream().map(Role::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder roles(Collection<Role> roles) {
            this.roles = _roleListTypeCopier.copy(roles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roles(Role ... roles) {
            this.roles(Arrays.asList(roles));
            return this;
        }

        public final void setRoles(Collection<Role.BuilderImpl> roles) {
            this.roles = _roleListTypeCopier.copyFromBuilder(roles);
        }

        public InstanceProfile build() {
            return new InstanceProfile(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceProfile> {
        public Builder path(String var1);

        public Builder instanceProfileName(String var1);

        public Builder instanceProfileId(String var1);

        public Builder arn(String var1);

        public Builder createDate(Instant var1);

        public Builder roles(Collection<Role> var1);

        public Builder roles(Role ... var1);
    }
}

