/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteRolePolicyRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteRolePolicyRequest> {
    private final String roleName;
    private final String policyName;

    private DeleteRolePolicyRequest(BuilderImpl builder) {
        this.roleName = builder.roleName;
        this.policyName = builder.policyName;
    }

    public String roleName() {
        return this.roleName;
    }

    public String policyName() {
        return this.policyName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRolePolicyRequest)) {
            return false;
        }
        DeleteRolePolicyRequest other = (DeleteRolePolicyRequest)((Object)obj);
        return Objects.equals(this.roleName(), other.roleName()) && Objects.equals(this.policyName(), other.policyName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.roleName() != null) {
            sb.append("RoleName: ").append(this.roleName()).append(",");
        }
        if (this.policyName() != null) {
            sb.append("PolicyName: ").append(this.policyName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoleName": {
                return Optional.of(clazz.cast(this.roleName()));
            }
            case "PolicyName": {
                return Optional.of(clazz.cast(this.policyName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String roleName;
        private String policyName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRolePolicyRequest model) {
            this.roleName(model.roleName);
            this.policyName(model.policyName);
        }

        public final String getRoleName() {
            return this.roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public DeleteRolePolicyRequest build() {
            return new DeleteRolePolicyRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteRolePolicyRequest> {
        public Builder roleName(String var1);

        public Builder policyName(String var1);
    }
}

