/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AttachGroupPolicyRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AttachGroupPolicyRequest> {
    private final String groupName;
    private final String policyArn;

    private AttachGroupPolicyRequest(BuilderImpl builder) {
        this.groupName = builder.groupName;
        this.policyArn = builder.policyArn;
    }

    public String groupName() {
        return this.groupName;
    }

    public String policyArn() {
        return this.policyArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachGroupPolicyRequest)) {
            return false;
        }
        AttachGroupPolicyRequest other = (AttachGroupPolicyRequest)((Object)obj);
        return Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.policyArn(), other.policyArn());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.groupName() != null) {
            sb.append("GroupName: ").append(this.groupName()).append(",");
        }
        if (this.policyArn() != null) {
            sb.append("PolicyArn: ").append(this.policyArn()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupName": {
                return Optional.of(clazz.cast(this.groupName()));
            }
            case "PolicyArn": {
                return Optional.of(clazz.cast(this.policyArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String groupName;
        private String policyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachGroupPolicyRequest model) {
            this.groupName(model.groupName);
            this.policyArn(model.policyArn);
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getPolicyArn() {
            return this.policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        public AttachGroupPolicyRequest build() {
            return new AttachGroupPolicyRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AttachGroupPolicyRequest> {
        public Builder groupName(String var1);

        public Builder policyArn(String var1);
    }
}

