/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.iam.model.StatusType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AccessKey
implements ToCopyableBuilder<Builder, AccessKey> {
    private final String userName;
    private final String accessKeyId;
    private final String status;
    private final String secretAccessKey;
    private final Instant createDate;

    private AccessKey(BuilderImpl builder) {
        this.userName = builder.userName;
        this.accessKeyId = builder.accessKeyId;
        this.status = builder.status;
        this.secretAccessKey = builder.secretAccessKey;
        this.createDate = builder.createDate;
    }

    public String userName() {
        return this.userName;
    }

    public String accessKeyId() {
        return this.accessKeyId;
    }

    public StatusType status() {
        return StatusType.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public String secretAccessKey() {
        return this.secretAccessKey;
    }

    public Instant createDate() {
        return this.createDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretAccessKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessKey)) {
            return false;
        }
        AccessKey other = (AccessKey)obj;
        return Objects.equals(this.userName(), other.userName()) && Objects.equals(this.accessKeyId(), other.accessKeyId()) && Objects.equals(this.statusString(), other.statusString()) && Objects.equals(this.secretAccessKey(), other.secretAccessKey()) && Objects.equals(this.createDate(), other.createDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.userName() != null) {
            sb.append("UserName: ").append(this.userName()).append(",");
        }
        if (this.accessKeyId() != null) {
            sb.append("AccessKeyId: ").append(this.accessKeyId()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (this.secretAccessKey() != null) {
            sb.append("SecretAccessKey: ").append(this.secretAccessKey()).append(",");
        }
        if (this.createDate() != null) {
            sb.append("CreateDate: ").append(this.createDate()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.of(clazz.cast(this.userName()));
            }
            case "AccessKeyId": {
                return Optional.of(clazz.cast(this.accessKeyId()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "SecretAccessKey": {
                return Optional.of(clazz.cast(this.secretAccessKey()));
            }
            case "CreateDate": {
                return Optional.of(clazz.cast(this.createDate()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String userName;
        private String accessKeyId;
        private String status;
        private String secretAccessKey;
        private Instant createDate;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessKey model) {
            this.userName(model.userName);
            this.accessKeyId(model.accessKeyId);
            this.status(model.status);
            this.secretAccessKey(model.secretAccessKey);
            this.createDate(model.createDate);
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getAccessKeyId() {
            return this.accessKeyId;
        }

        @Override
        public final Builder accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public final void setAccessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StatusType status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getSecretAccessKey() {
            return this.secretAccessKey;
        }

        @Override
        public final Builder secretAccessKey(String secretAccessKey) {
            this.secretAccessKey = secretAccessKey;
            return this;
        }

        public final void setSecretAccessKey(String secretAccessKey) {
            this.secretAccessKey = secretAccessKey;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public AccessKey build() {
            return new AccessKey(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AccessKey> {
        public Builder userName(String var1);

        public Builder accessKeyId(String var1);

        public Builder status(String var1);

        public Builder status(StatusType var1);

        public Builder secretAccessKey(String var1);

        public Builder createDate(Instant var1);
    }
}

