/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.iam.model.DeletePolicyVersionRequest;

public class DeletePolicyVersionRequestMarshaller
implements Marshaller<Request<DeletePolicyVersionRequest>, DeletePolicyVersionRequest> {
    public Request<DeletePolicyVersionRequest> marshall(DeletePolicyVersionRequest deletePolicyVersionRequest) {
        if (deletePolicyVersionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deletePolicyVersionRequest, "IAMClient");
        request.addParameter("Action", "DeletePolicyVersion");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (deletePolicyVersionRequest.policyArn() != null) {
            request.addParameter("PolicyArn", StringUtils.fromString((String)deletePolicyVersionRequest.policyArn()));
        }
        if (deletePolicyVersionRequest.versionId() != null) {
            request.addParameter("VersionId", StringUtils.fromString((String)deletePolicyVersionRequest.versionId()));
        }
        return request;
    }
}

