/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.iam.model.CreateOpenIDConnectProviderRequest;

public class CreateOpenIDConnectProviderRequestMarshaller
implements Marshaller<Request<CreateOpenIDConnectProviderRequest>, CreateOpenIDConnectProviderRequest> {
    public Request<CreateOpenIDConnectProviderRequest> marshall(CreateOpenIDConnectProviderRequest createOpenIDConnectProviderRequest) {
        List<String> thumbprintListList;
        List<String> clientIDListList;
        if (createOpenIDConnectProviderRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createOpenIDConnectProviderRequest, "IAMClient");
        request.addParameter("Action", "CreateOpenIDConnectProvider");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (createOpenIDConnectProviderRequest.url() != null) {
            request.addParameter("Url", StringUtils.fromString((String)createOpenIDConnectProviderRequest.url()));
        }
        if ((clientIDListList = createOpenIDConnectProviderRequest.clientIDList()) != null) {
            if (!clientIDListList.isEmpty()) {
                int clientIDListListIndex = 1;
                for (String clientIDListListValue : clientIDListList) {
                    if (clientIDListListValue != null) {
                        request.addParameter("ClientIDList.member." + clientIDListListIndex, StringUtils.fromString((String)clientIDListListValue));
                    }
                    ++clientIDListListIndex;
                }
            } else {
                request.addParameter("ClientIDList", "");
            }
        }
        if ((thumbprintListList = createOpenIDConnectProviderRequest.thumbprintList()) != null) {
            if (!thumbprintListList.isEmpty()) {
                int thumbprintListListIndex = 1;
                for (String thumbprintListListValue : thumbprintListList) {
                    if (thumbprintListListValue != null) {
                        request.addParameter("ThumbprintList.member." + thumbprintListListIndex, StringUtils.fromString((String)thumbprintListListValue));
                    }
                    ++thumbprintListListIndex;
                }
            } else {
                request.addParameter("ThumbprintList", "");
            }
        }
        return request;
    }
}

