/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.iam.model.StatusType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateServiceSpecificCredentialRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateServiceSpecificCredentialRequest> {
    private final String userName;
    private final String serviceSpecificCredentialId;
    private final String status;

    private UpdateServiceSpecificCredentialRequest(BuilderImpl builder) {
        this.userName = builder.userName;
        this.serviceSpecificCredentialId = builder.serviceSpecificCredentialId;
        this.status = builder.status;
    }

    public String userName() {
        return this.userName;
    }

    public String serviceSpecificCredentialId() {
        return this.serviceSpecificCredentialId;
    }

    public StatusType status() {
        return StatusType.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.userName() == null ? 0 : this.userName().hashCode());
        hashCode = 31 * hashCode + (this.serviceSpecificCredentialId() == null ? 0 : this.serviceSpecificCredentialId().hashCode());
        hashCode = 31 * hashCode + (this.statusString() == null ? 0 : this.statusString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServiceSpecificCredentialRequest)) {
            return false;
        }
        UpdateServiceSpecificCredentialRequest other = (UpdateServiceSpecificCredentialRequest)((Object)obj);
        if (other.userName() == null ^ this.userName() == null) {
            return false;
        }
        if (other.userName() != null && !other.userName().equals(this.userName())) {
            return false;
        }
        if (other.serviceSpecificCredentialId() == null ^ this.serviceSpecificCredentialId() == null) {
            return false;
        }
        if (other.serviceSpecificCredentialId() != null && !other.serviceSpecificCredentialId().equals(this.serviceSpecificCredentialId())) {
            return false;
        }
        if (other.statusString() == null ^ this.statusString() == null) {
            return false;
        }
        return other.statusString() == null || other.statusString().equals(this.statusString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.userName() != null) {
            sb.append("UserName: ").append(this.userName()).append(",");
        }
        if (this.serviceSpecificCredentialId() != null) {
            sb.append("ServiceSpecificCredentialId: ").append(this.serviceSpecificCredentialId()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.of(clazz.cast(this.userName()));
            }
            case "ServiceSpecificCredentialId": {
                return Optional.of(clazz.cast(this.serviceSpecificCredentialId()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String userName;
        private String serviceSpecificCredentialId;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServiceSpecificCredentialRequest model) {
            this.userName(model.userName);
            this.serviceSpecificCredentialId(model.serviceSpecificCredentialId);
            this.status(model.status);
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getServiceSpecificCredentialId() {
            return this.serviceSpecificCredentialId;
        }

        @Override
        public final Builder serviceSpecificCredentialId(String serviceSpecificCredentialId) {
            this.serviceSpecificCredentialId = serviceSpecificCredentialId;
            return this;
        }

        public final void setServiceSpecificCredentialId(String serviceSpecificCredentialId) {
            this.serviceSpecificCredentialId = serviceSpecificCredentialId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StatusType status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public UpdateServiceSpecificCredentialRequest build() {
            return new UpdateServiceSpecificCredentialRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateServiceSpecificCredentialRequest> {
        public Builder userName(String var1);

        public Builder serviceSpecificCredentialId(String var1);

        public Builder status(String var1);

        public Builder status(StatusType var1);
    }
}

