/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.iam.model.ContextKeyNamesResultListTypeCopier;
import software.amazon.awssdk.services.iam.model.EvalDecisionDetailsTypeCopier;
import software.amazon.awssdk.services.iam.model.PolicyEvaluationDecisionType;
import software.amazon.awssdk.services.iam.model.Statement;
import software.amazon.awssdk.services.iam.model.StatementListTypeCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ResourceSpecificResult
implements ToCopyableBuilder<Builder, ResourceSpecificResult> {
    private final String evalResourceName;
    private final String evalResourceDecision;
    private final List<Statement> matchedStatements;
    private final List<String> missingContextValues;
    private final Map<String, String> evalDecisionDetails;

    private ResourceSpecificResult(BuilderImpl builder) {
        this.evalResourceName = builder.evalResourceName;
        this.evalResourceDecision = builder.evalResourceDecision;
        this.matchedStatements = builder.matchedStatements;
        this.missingContextValues = builder.missingContextValues;
        this.evalDecisionDetails = builder.evalDecisionDetails;
    }

    public String evalResourceName() {
        return this.evalResourceName;
    }

    public PolicyEvaluationDecisionType evalResourceDecision() {
        return PolicyEvaluationDecisionType.fromValue(this.evalResourceDecision);
    }

    public String evalResourceDecisionString() {
        return this.evalResourceDecision;
    }

    public List<Statement> matchedStatements() {
        return this.matchedStatements;
    }

    public List<String> missingContextValues() {
        return this.missingContextValues;
    }

    public Map<String, PolicyEvaluationDecisionType> evalDecisionDetails() {
        return TypeConverter.convert(this.evalDecisionDetails, Function.identity(), PolicyEvaluationDecisionType::fromValue, (k, v) -> true);
    }

    public Map<String, String> evalDecisionDetailsStrings() {
        return this.evalDecisionDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.evalResourceName() == null ? 0 : this.evalResourceName().hashCode());
        hashCode = 31 * hashCode + (this.evalResourceDecisionString() == null ? 0 : this.evalResourceDecisionString().hashCode());
        hashCode = 31 * hashCode + (this.matchedStatements() == null ? 0 : this.matchedStatements().hashCode());
        hashCode = 31 * hashCode + (this.missingContextValues() == null ? 0 : this.missingContextValues().hashCode());
        hashCode = 31 * hashCode + (this.evalDecisionDetailsStrings() == null ? 0 : this.evalDecisionDetailsStrings().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceSpecificResult)) {
            return false;
        }
        ResourceSpecificResult other = (ResourceSpecificResult)obj;
        if (other.evalResourceName() == null ^ this.evalResourceName() == null) {
            return false;
        }
        if (other.evalResourceName() != null && !other.evalResourceName().equals(this.evalResourceName())) {
            return false;
        }
        if (other.evalResourceDecisionString() == null ^ this.evalResourceDecisionString() == null) {
            return false;
        }
        if (other.evalResourceDecisionString() != null && !other.evalResourceDecisionString().equals(this.evalResourceDecisionString())) {
            return false;
        }
        if (other.matchedStatements() == null ^ this.matchedStatements() == null) {
            return false;
        }
        if (other.matchedStatements() != null && !other.matchedStatements().equals(this.matchedStatements())) {
            return false;
        }
        if (other.missingContextValues() == null ^ this.missingContextValues() == null) {
            return false;
        }
        if (other.missingContextValues() != null && !other.missingContextValues().equals(this.missingContextValues())) {
            return false;
        }
        if (other.evalDecisionDetailsStrings() == null ^ this.evalDecisionDetailsStrings() == null) {
            return false;
        }
        return other.evalDecisionDetailsStrings() == null || other.evalDecisionDetailsStrings().equals(this.evalDecisionDetailsStrings());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.evalResourceName() != null) {
            sb.append("EvalResourceName: ").append(this.evalResourceName()).append(",");
        }
        if (this.evalResourceDecisionString() != null) {
            sb.append("EvalResourceDecision: ").append(this.evalResourceDecisionString()).append(",");
        }
        if (this.matchedStatements() != null) {
            sb.append("MatchedStatements: ").append(this.matchedStatements()).append(",");
        }
        if (this.missingContextValues() != null) {
            sb.append("MissingContextValues: ").append(this.missingContextValues()).append(",");
        }
        if (this.evalDecisionDetailsStrings() != null) {
            sb.append("EvalDecisionDetails: ").append(this.evalDecisionDetailsStrings()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EvalResourceName": {
                return Optional.of(clazz.cast(this.evalResourceName()));
            }
            case "EvalResourceDecision": {
                return Optional.of(clazz.cast(this.evalResourceDecisionString()));
            }
            case "MatchedStatements": {
                return Optional.of(clazz.cast(this.matchedStatements()));
            }
            case "MissingContextValues": {
                return Optional.of(clazz.cast(this.missingContextValues()));
            }
            case "EvalDecisionDetails": {
                return Optional.of(clazz.cast(this.evalDecisionDetailsStrings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String evalResourceName;
        private String evalResourceDecision;
        private List<Statement> matchedStatements;
        private List<String> missingContextValues;
        private Map<String, String> evalDecisionDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceSpecificResult model) {
            this.evalResourceName(model.evalResourceName);
            this.evalResourceDecision(model.evalResourceDecision);
            this.matchedStatements(model.matchedStatements);
            this.missingContextValues(model.missingContextValues);
            this.evalDecisionDetails(model.evalDecisionDetails);
        }

        public final String getEvalResourceName() {
            return this.evalResourceName;
        }

        @Override
        public final Builder evalResourceName(String evalResourceName) {
            this.evalResourceName = evalResourceName;
            return this;
        }

        public final void setEvalResourceName(String evalResourceName) {
            this.evalResourceName = evalResourceName;
        }

        public final String getEvalResourceDecision() {
            return this.evalResourceDecision;
        }

        @Override
        public final Builder evalResourceDecision(String evalResourceDecision) {
            this.evalResourceDecision = evalResourceDecision;
            return this;
        }

        @Override
        public final Builder evalResourceDecision(PolicyEvaluationDecisionType evalResourceDecision) {
            this.evalResourceDecision(evalResourceDecision.toString());
            return this;
        }

        public final void setEvalResourceDecision(String evalResourceDecision) {
            this.evalResourceDecision = evalResourceDecision;
        }

        public final Collection<Statement.Builder> getMatchedStatements() {
            return this.matchedStatements != null ? (Collection)this.matchedStatements.stream().map(Statement::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder matchedStatements(Collection<Statement> matchedStatements) {
            this.matchedStatements = StatementListTypeCopier.copy(matchedStatements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchedStatements(Statement ... matchedStatements) {
            this.matchedStatements(Arrays.asList(matchedStatements));
            return this;
        }

        public final void setMatchedStatements(Collection<Statement.BuilderImpl> matchedStatements) {
            this.matchedStatements = StatementListTypeCopier.copyFromBuilder(matchedStatements);
        }

        public final Collection<String> getMissingContextValues() {
            return this.missingContextValues;
        }

        @Override
        public final Builder missingContextValues(Collection<String> missingContextValues) {
            this.missingContextValues = ContextKeyNamesResultListTypeCopier.copy(missingContextValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder missingContextValues(String ... missingContextValues) {
            this.missingContextValues(Arrays.asList(missingContextValues));
            return this;
        }

        public final void setMissingContextValues(Collection<String> missingContextValues) {
            this.missingContextValues = ContextKeyNamesResultListTypeCopier.copy(missingContextValues);
        }

        public final Map<String, String> getEvalDecisionDetails() {
            return this.evalDecisionDetails;
        }

        @Override
        public final Builder evalDecisionDetails(Map<String, String> evalDecisionDetails) {
            this.evalDecisionDetails = EvalDecisionDetailsTypeCopier.copy(evalDecisionDetails);
            return this;
        }

        public final void setEvalDecisionDetails(Map<String, String> evalDecisionDetails) {
            this.evalDecisionDetails = EvalDecisionDetailsTypeCopier.copy(evalDecisionDetails);
        }

        public ResourceSpecificResult build() {
            return new ResourceSpecificResult(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResourceSpecificResult> {
        public Builder evalResourceName(String var1);

        public Builder evalResourceDecision(String var1);

        public Builder evalResourceDecision(PolicyEvaluationDecisionType var1);

        public Builder matchedStatements(Collection<Statement> var1);

        public Builder matchedStatements(Statement ... var1);

        public Builder missingContextValues(Collection<String> var1);

        public Builder missingContextValues(String ... var1);

        public Builder evalDecisionDetails(Map<String, String> var1);
    }
}

