/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.iam.model.PolicyGroup;
import software.amazon.awssdk.services.iam.model.PolicyGroupListTypeCopier;
import software.amazon.awssdk.services.iam.model.PolicyRole;
import software.amazon.awssdk.services.iam.model.PolicyRoleListTypeCopier;
import software.amazon.awssdk.services.iam.model.PolicyUser;
import software.amazon.awssdk.services.iam.model.PolicyUserListTypeCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListEntitiesForPolicyResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListEntitiesForPolicyResponse> {
    private final List<PolicyGroup> policyGroups;
    private final List<PolicyUser> policyUsers;
    private final List<PolicyRole> policyRoles;
    private final Boolean isTruncated;
    private final String marker;

    private ListEntitiesForPolicyResponse(BuilderImpl builder) {
        this.policyGroups = builder.policyGroups;
        this.policyUsers = builder.policyUsers;
        this.policyRoles = builder.policyRoles;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    public List<PolicyGroup> policyGroups() {
        return this.policyGroups;
    }

    public List<PolicyUser> policyUsers() {
        return this.policyUsers;
    }

    public List<PolicyRole> policyRoles() {
        return this.policyRoles;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.policyGroups() == null ? 0 : this.policyGroups().hashCode());
        hashCode = 31 * hashCode + (this.policyUsers() == null ? 0 : this.policyUsers().hashCode());
        hashCode = 31 * hashCode + (this.policyRoles() == null ? 0 : this.policyRoles().hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEntitiesForPolicyResponse)) {
            return false;
        }
        ListEntitiesForPolicyResponse other = (ListEntitiesForPolicyResponse)((Object)obj);
        if (other.policyGroups() == null ^ this.policyGroups() == null) {
            return false;
        }
        if (other.policyGroups() != null && !other.policyGroups().equals(this.policyGroups())) {
            return false;
        }
        if (other.policyUsers() == null ^ this.policyUsers() == null) {
            return false;
        }
        if (other.policyUsers() != null && !other.policyUsers().equals(this.policyUsers())) {
            return false;
        }
        if (other.policyRoles() == null ^ this.policyRoles() == null) {
            return false;
        }
        if (other.policyRoles() != null && !other.policyRoles().equals(this.policyRoles())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.policyGroups() != null) {
            sb.append("PolicyGroups: ").append(this.policyGroups()).append(",");
        }
        if (this.policyUsers() != null) {
            sb.append("PolicyUsers: ").append(this.policyUsers()).append(",");
        }
        if (this.policyRoles() != null) {
            sb.append("PolicyRoles: ").append(this.policyRoles()).append(",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: ").append(this.isTruncated()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyGroups": {
                return Optional.of(clazz.cast(this.policyGroups()));
            }
            case "PolicyUsers": {
                return Optional.of(clazz.cast(this.policyUsers()));
            }
            case "PolicyRoles": {
                return Optional.of(clazz.cast(this.policyRoles()));
            }
            case "IsTruncated": {
                return Optional.of(clazz.cast(this.isTruncated()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<PolicyGroup> policyGroups;
        private List<PolicyUser> policyUsers;
        private List<PolicyRole> policyRoles;
        private Boolean isTruncated;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEntitiesForPolicyResponse model) {
            this.policyGroups(model.policyGroups);
            this.policyUsers(model.policyUsers);
            this.policyRoles(model.policyRoles);
            this.isTruncated(model.isTruncated);
            this.marker(model.marker);
        }

        public final Collection<PolicyGroup.Builder> getPolicyGroups() {
            return this.policyGroups != null ? (Collection)this.policyGroups.stream().map(PolicyGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder policyGroups(Collection<PolicyGroup> policyGroups) {
            this.policyGroups = PolicyGroupListTypeCopier.copy(policyGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyGroups(PolicyGroup ... policyGroups) {
            this.policyGroups(Arrays.asList(policyGroups));
            return this;
        }

        public final void setPolicyGroups(Collection<PolicyGroup.BuilderImpl> policyGroups) {
            this.policyGroups = PolicyGroupListTypeCopier.copyFromBuilder(policyGroups);
        }

        public final Collection<PolicyUser.Builder> getPolicyUsers() {
            return this.policyUsers != null ? (Collection)this.policyUsers.stream().map(PolicyUser::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder policyUsers(Collection<PolicyUser> policyUsers) {
            this.policyUsers = PolicyUserListTypeCopier.copy(policyUsers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyUsers(PolicyUser ... policyUsers) {
            this.policyUsers(Arrays.asList(policyUsers));
            return this;
        }

        public final void setPolicyUsers(Collection<PolicyUser.BuilderImpl> policyUsers) {
            this.policyUsers = PolicyUserListTypeCopier.copyFromBuilder(policyUsers);
        }

        public final Collection<PolicyRole.Builder> getPolicyRoles() {
            return this.policyRoles != null ? (Collection)this.policyRoles.stream().map(PolicyRole::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder policyRoles(Collection<PolicyRole> policyRoles) {
            this.policyRoles = PolicyRoleListTypeCopier.copy(policyRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyRoles(PolicyRole ... policyRoles) {
            this.policyRoles(Arrays.asList(policyRoles));
            return this;
        }

        public final void setPolicyRoles(Collection<PolicyRole.BuilderImpl> policyRoles) {
            this.policyRoles = PolicyRoleListTypeCopier.copyFromBuilder(policyRoles);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public ListEntitiesForPolicyResponse build() {
            return new ListEntitiesForPolicyResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListEntitiesForPolicyResponse> {
        public Builder policyGroups(Collection<PolicyGroup> var1);

        public Builder policyGroups(PolicyGroup ... var1);

        public Builder policyUsers(Collection<PolicyUser> var1);

        public Builder policyUsers(PolicyUser ... var1);

        public Builder policyRoles(Collection<PolicyRole> var1);

        public Builder policyRoles(PolicyRole ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);
    }
}

