/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.core.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.iam.model.ReportFormatType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetCredentialReportResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetCredentialReportResponse> {
    private final ByteBuffer content;
    private final String reportFormat;
    private final Instant generatedTime;

    private GetCredentialReportResponse(BuilderImpl builder) {
        this.content = builder.content;
        this.reportFormat = builder.reportFormat;
        this.generatedTime = builder.generatedTime;
    }

    public ByteBuffer content() {
        return this.content == null ? null : this.content.asReadOnlyBuffer();
    }

    public ReportFormatType reportFormat() {
        return ReportFormatType.fromValue(this.reportFormat);
    }

    public String reportFormatString() {
        return this.reportFormat;
    }

    public Instant generatedTime() {
        return this.generatedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.content() == null ? 0 : this.content().hashCode());
        hashCode = 31 * hashCode + (this.reportFormatString() == null ? 0 : this.reportFormatString().hashCode());
        hashCode = 31 * hashCode + (this.generatedTime() == null ? 0 : this.generatedTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCredentialReportResponse)) {
            return false;
        }
        GetCredentialReportResponse other = (GetCredentialReportResponse)((Object)obj);
        if (other.content() == null ^ this.content() == null) {
            return false;
        }
        if (other.content() != null && !other.content().equals(this.content())) {
            return false;
        }
        if (other.reportFormatString() == null ^ this.reportFormatString() == null) {
            return false;
        }
        if (other.reportFormatString() != null && !other.reportFormatString().equals(this.reportFormatString())) {
            return false;
        }
        if (other.generatedTime() == null ^ this.generatedTime() == null) {
            return false;
        }
        return other.generatedTime() == null || other.generatedTime().equals(this.generatedTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.content() != null) {
            sb.append("Content: ").append(this.content()).append(",");
        }
        if (this.reportFormatString() != null) {
            sb.append("ReportFormat: ").append(this.reportFormatString()).append(",");
        }
        if (this.generatedTime() != null) {
            sb.append("GeneratedTime: ").append(this.generatedTime()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Content": {
                return Optional.of(clazz.cast(this.content()));
            }
            case "ReportFormat": {
                return Optional.of(clazz.cast(this.reportFormatString()));
            }
            case "GeneratedTime": {
                return Optional.of(clazz.cast(this.generatedTime()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private ByteBuffer content;
        private String reportFormat;
        private Instant generatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCredentialReportResponse model) {
            this.content(model.content);
            this.reportFormat(model.reportFormat);
            this.generatedTime(model.generatedTime);
        }

        public final ByteBuffer getContent() {
            return this.content;
        }

        @Override
        public final Builder content(ByteBuffer content) {
            this.content = StandardMemberCopier.copy((ByteBuffer)content);
            return this;
        }

        public final void setContent(ByteBuffer content) {
            this.content = StandardMemberCopier.copy((ByteBuffer)content);
        }

        public final String getReportFormat() {
            return this.reportFormat;
        }

        @Override
        public final Builder reportFormat(String reportFormat) {
            this.reportFormat = reportFormat;
            return this;
        }

        @Override
        public final Builder reportFormat(ReportFormatType reportFormat) {
            this.reportFormat(reportFormat.toString());
            return this;
        }

        public final void setReportFormat(String reportFormat) {
            this.reportFormat = reportFormat;
        }

        public final Instant getGeneratedTime() {
            return this.generatedTime;
        }

        @Override
        public final Builder generatedTime(Instant generatedTime) {
            this.generatedTime = generatedTime;
            return this;
        }

        public final void setGeneratedTime(Instant generatedTime) {
            this.generatedTime = generatedTime;
        }

        public GetCredentialReportResponse build() {
            return new GetCredentialReportResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetCredentialReportResponse> {
        public Builder content(ByteBuffer var1);

        public Builder reportFormat(String var1);

        public Builder reportFormat(ReportFormatType var1);

        public Builder generatedTime(Instant var1);
    }
}

