/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteSigningCertificateRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteSigningCertificateRequest> {
    private final String userName;
    private final String certificateId;

    private DeleteSigningCertificateRequest(BuilderImpl builder) {
        this.userName = builder.userName;
        this.certificateId = builder.certificateId;
    }

    public String userName() {
        return this.userName;
    }

    public String certificateId() {
        return this.certificateId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.userName() == null ? 0 : this.userName().hashCode());
        hashCode = 31 * hashCode + (this.certificateId() == null ? 0 : this.certificateId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteSigningCertificateRequest)) {
            return false;
        }
        DeleteSigningCertificateRequest other = (DeleteSigningCertificateRequest)((Object)obj);
        if (other.userName() == null ^ this.userName() == null) {
            return false;
        }
        if (other.userName() != null && !other.userName().equals(this.userName())) {
            return false;
        }
        if (other.certificateId() == null ^ this.certificateId() == null) {
            return false;
        }
        return other.certificateId() == null || other.certificateId().equals(this.certificateId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.userName() != null) {
            sb.append("UserName: ").append(this.userName()).append(",");
        }
        if (this.certificateId() != null) {
            sb.append("CertificateId: ").append(this.certificateId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.of(clazz.cast(this.userName()));
            }
            case "CertificateId": {
                return Optional.of(clazz.cast(this.certificateId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String userName;
        private String certificateId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteSigningCertificateRequest model) {
            this.userName(model.userName);
            this.certificateId(model.certificateId);
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getCertificateId() {
            return this.certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        public DeleteSigningCertificateRequest build() {
            return new DeleteSigningCertificateRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteSigningCertificateRequest> {
        public Builder userName(String var1);

        public Builder certificateId(String var1);
    }
}

