/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteSSHPublicKeyRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteSSHPublicKeyRequest> {
    private final String userName;
    private final String sshPublicKeyId;

    private DeleteSSHPublicKeyRequest(BuilderImpl builder) {
        this.userName = builder.userName;
        this.sshPublicKeyId = builder.sshPublicKeyId;
    }

    public String userName() {
        return this.userName;
    }

    public String sshPublicKeyId() {
        return this.sshPublicKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.userName() == null ? 0 : this.userName().hashCode());
        hashCode = 31 * hashCode + (this.sshPublicKeyId() == null ? 0 : this.sshPublicKeyId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteSSHPublicKeyRequest)) {
            return false;
        }
        DeleteSSHPublicKeyRequest other = (DeleteSSHPublicKeyRequest)((Object)obj);
        if (other.userName() == null ^ this.userName() == null) {
            return false;
        }
        if (other.userName() != null && !other.userName().equals(this.userName())) {
            return false;
        }
        if (other.sshPublicKeyId() == null ^ this.sshPublicKeyId() == null) {
            return false;
        }
        return other.sshPublicKeyId() == null || other.sshPublicKeyId().equals(this.sshPublicKeyId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.userName() != null) {
            sb.append("UserName: ").append(this.userName()).append(",");
        }
        if (this.sshPublicKeyId() != null) {
            sb.append("SSHPublicKeyId: ").append(this.sshPublicKeyId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.of(clazz.cast(this.userName()));
            }
            case "SSHPublicKeyId": {
                return Optional.of(clazz.cast(this.sshPublicKeyId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String userName;
        private String sshPublicKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteSSHPublicKeyRequest model) {
            this.userName(model.userName);
            this.sshPublicKeyId(model.sshPublicKeyId);
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getSSHPublicKeyId() {
            return this.sshPublicKeyId;
        }

        @Override
        public final Builder sshPublicKeyId(String sshPublicKeyId) {
            this.sshPublicKeyId = sshPublicKeyId;
            return this;
        }

        public final void setSSHPublicKeyId(String sshPublicKeyId) {
            this.sshPublicKeyId = sshPublicKeyId;
        }

        public DeleteSSHPublicKeyRequest build() {
            return new DeleteSSHPublicKeyRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteSSHPublicKeyRequest> {
        public Builder userName(String var1);

        public Builder sshPublicKeyId(String var1);
    }
}

