/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteAccessKeyRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteAccessKeyRequest> {
    private final String userName;
    private final String accessKeyId;

    private DeleteAccessKeyRequest(BuilderImpl builder) {
        this.userName = builder.userName;
        this.accessKeyId = builder.accessKeyId;
    }

    public String userName() {
        return this.userName;
    }

    public String accessKeyId() {
        return this.accessKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.userName() == null ? 0 : this.userName().hashCode());
        hashCode = 31 * hashCode + (this.accessKeyId() == null ? 0 : this.accessKeyId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAccessKeyRequest)) {
            return false;
        }
        DeleteAccessKeyRequest other = (DeleteAccessKeyRequest)((Object)obj);
        if (other.userName() == null ^ this.userName() == null) {
            return false;
        }
        if (other.userName() != null && !other.userName().equals(this.userName())) {
            return false;
        }
        if (other.accessKeyId() == null ^ this.accessKeyId() == null) {
            return false;
        }
        return other.accessKeyId() == null || other.accessKeyId().equals(this.accessKeyId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.userName() != null) {
            sb.append("UserName: ").append(this.userName()).append(",");
        }
        if (this.accessKeyId() != null) {
            sb.append("AccessKeyId: ").append(this.accessKeyId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.of(clazz.cast(this.userName()));
            }
            case "AccessKeyId": {
                return Optional.of(clazz.cast(this.accessKeyId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String userName;
        private String accessKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAccessKeyRequest model) {
            this.userName(model.userName);
            this.accessKeyId(model.accessKeyId);
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getAccessKeyId() {
            return this.accessKeyId;
        }

        @Override
        public final Builder accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public final void setAccessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
        }

        public DeleteAccessKeyRequest build() {
            return new DeleteAccessKeyRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteAccessKeyRequest> {
        public Builder userName(String var1);

        public Builder accessKeyId(String var1);
    }
}

