/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateServiceSpecificCredentialRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateServiceSpecificCredentialRequest> {
    private final String userName;
    private final String serviceName;

    private CreateServiceSpecificCredentialRequest(BuilderImpl builder) {
        this.userName = builder.userName;
        this.serviceName = builder.serviceName;
    }

    public String userName() {
        return this.userName;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.userName() == null ? 0 : this.userName().hashCode());
        hashCode = 31 * hashCode + (this.serviceName() == null ? 0 : this.serviceName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServiceSpecificCredentialRequest)) {
            return false;
        }
        CreateServiceSpecificCredentialRequest other = (CreateServiceSpecificCredentialRequest)((Object)obj);
        if (other.userName() == null ^ this.userName() == null) {
            return false;
        }
        if (other.userName() != null && !other.userName().equals(this.userName())) {
            return false;
        }
        if (other.serviceName() == null ^ this.serviceName() == null) {
            return false;
        }
        return other.serviceName() == null || other.serviceName().equals(this.serviceName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.userName() != null) {
            sb.append("UserName: ").append(this.userName()).append(",");
        }
        if (this.serviceName() != null) {
            sb.append("ServiceName: ").append(this.serviceName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.of(clazz.cast(this.userName()));
            }
            case "ServiceName": {
                return Optional.of(clazz.cast(this.serviceName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String userName;
        private String serviceName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServiceSpecificCredentialRequest model) {
            this.userName(model.userName);
            this.serviceName(model.serviceName);
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public CreateServiceSpecificCredentialRequest build() {
            return new CreateServiceSpecificCredentialRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateServiceSpecificCredentialRequest> {
        public Builder userName(String var1);

        public Builder serviceName(String var1);
    }
}

